/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="If exception, presume unaligned")
public final class UnsafeAccess {
    private static final Log LOG = LogFactory.getLog(UnsafeAccess.class);
    public static final Unsafe theUnsafe;
    public static final int BYTE_ARRAY_BASE_OFFSET;
    public static final boolean LITTLE_ENDIAN;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeAccess() {
    }

    public static void copy(byte[] src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress = destOffset;
        byte[] destBase = null;
        if (dest.isDirect()) {
            destAddress += ((DirectBuffer)((Object)dest)).address();
        } else {
            destAddress = destAddress + (long)BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        long srcAddress = (long)srcOffset + (long)BYTE_ARRAY_BASE_OFFSET;
        UnsafeAccess.unsafeCopy(src, srcAddress, destBase, destAddress, length);
    }

    private static void unsafeCopy(Object src, long srcAddr, Object dst, long destAddr, long len) {
        while (len > 0L) {
            long size = len > 0x100000L ? 0x100000L : len;
            theUnsafe.copyMemory(src, srcAddr, dst, destAddr, size);
            len -= size;
            srcAddr += size;
            destAddr += size;
        }
    }

    public static void copy(ByteBuffer src, int srcOffset, byte[] dest, int destOffset, int length) {
        long srcAddress = srcOffset;
        byte[] srcBase = null;
        if (src.isDirect()) {
            srcAddress += ((DirectBuffer)((Object)src)).address();
        } else {
            srcAddress = srcAddress + (long)BYTE_ARRAY_BASE_OFFSET + (long)src.arrayOffset();
            srcBase = src.array();
        }
        long destAddress = (long)destOffset + (long)BYTE_ARRAY_BASE_OFFSET;
        UnsafeAccess.unsafeCopy(srcBase, srcAddress, dest, destAddress, length);
    }

    public static void copy(ByteBuffer src, int srcOffset, ByteBuffer dest, int destOffset, int length) {
        long destAddress;
        long srcAddress;
        byte[] srcBase = null;
        byte[] destBase = null;
        if (src.isDirect()) {
            srcAddress = (long)srcOffset + ((DirectBuffer)((Object)src)).address();
        } else {
            srcAddress = (long)srcOffset + (long)src.arrayOffset() + (long)BYTE_ARRAY_BASE_OFFSET;
            srcBase = src.array();
        }
        if (dest.isDirect()) {
            destAddress = (long)destOffset + ((DirectBuffer)((Object)dest)).address();
        } else {
            destAddress = (long)destOffset + (long)BYTE_ARRAY_BASE_OFFSET + (long)dest.arrayOffset();
            destBase = dest.array();
        }
        UnsafeAccess.unsafeCopy(srcBase, srcAddress, destBase, destAddress, length);
    }

    public static short toShort(byte[] bytes, int offset) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(theUnsafe.getShort(bytes, offset + BYTE_ARRAY_BASE_OFFSET));
        }
        return theUnsafe.getShort(bytes, offset + BYTE_ARRAY_BASE_OFFSET);
    }

    public static int toInt(byte[] bytes, int offset) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(theUnsafe.getInt(bytes, offset + BYTE_ARRAY_BASE_OFFSET));
        }
        return theUnsafe.getInt(bytes, offset + BYTE_ARRAY_BASE_OFFSET);
    }

    public static long toLong(byte[] bytes, int offset) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(theUnsafe.getLong(bytes, offset + BYTE_ARRAY_BASE_OFFSET));
        }
        return theUnsafe.getLong(bytes, offset + BYTE_ARRAY_BASE_OFFSET);
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (LITTLE_ENDIAN) {
            val = Short.reverseBytes(val);
        }
        theUnsafe.putShort(bytes, offset + BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 2;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        theUnsafe.putInt(bytes, offset + BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 4;
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (LITTLE_ENDIAN) {
            val = Long.reverseBytes(val);
        }
        theUnsafe.putLong(bytes, offset + BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 8;
    }

    public static short toShort(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(UnsafeAccess.getAsShort(buf, offset));
        }
        return UnsafeAccess.getAsShort(buf, offset);
    }

    static short getAsShort(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return theUnsafe.getShort(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return theUnsafe.getShort(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset);
    }

    public static int toInt(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(UnsafeAccess.getAsInt(buf, offset));
        }
        return UnsafeAccess.getAsInt(buf, offset);
    }

    static int getAsInt(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return theUnsafe.getInt(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return theUnsafe.getInt(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset);
    }

    public static long toLong(ByteBuffer buf, int offset) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(UnsafeAccess.getAsLong(buf, offset));
        }
        return UnsafeAccess.getAsLong(buf, offset);
    }

    static long getAsLong(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return theUnsafe.getLong(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return theUnsafe.getLong(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset);
    }

    public static int putInt(ByteBuffer buf, int offset, int val) {
        if (LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        if (buf.isDirect()) {
            theUnsafe.putInt(((DirectBuffer)((Object)buf)).address() + (long)offset, val);
        } else {
            theUnsafe.putInt(buf.array(), offset + buf.arrayOffset() + BYTE_ARRAY_BASE_OFFSET, val);
        }
        return offset + 4;
    }

    public static int putShort(ByteBuffer buf, int offset, short val) {
        if (LITTLE_ENDIAN) {
            val = Short.reverseBytes(val);
        }
        if (buf.isDirect()) {
            theUnsafe.putShort(((DirectBuffer)((Object)buf)).address() + (long)offset, val);
        } else {
            theUnsafe.putShort(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset, val);
        }
        return offset + 2;
    }

    public static int putLong(ByteBuffer buf, int offset, long val) {
        if (LITTLE_ENDIAN) {
            val = Long.reverseBytes(val);
        }
        if (buf.isDirect()) {
            theUnsafe.putLong(((DirectBuffer)((Object)buf)).address() + (long)offset, val);
        } else {
            theUnsafe.putLong(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset, val);
        }
        return offset + 8;
    }

    public static int putByte(ByteBuffer buf, int offset, byte b) {
        if (buf.isDirect()) {
            theUnsafe.putByte(((DirectBuffer)((Object)buf)).address() + (long)offset, b);
        } else {
            theUnsafe.putByte(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset, b);
        }
        return offset + 1;
    }

    public static byte toByte(ByteBuffer buf, int offset) {
        if (buf.isDirect()) {
            return theUnsafe.getByte(((DirectBuffer)((Object)buf)).address() + (long)offset);
        }
        return theUnsafe.getByte(buf.array(), BYTE_ARRAY_BASE_OFFSET + buf.arrayOffset() + offset);
    }

    static {
        LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (Throwable e) {
                    LOG.warn((Object)"sun.misc.Unsafe is not accessible", e);
                    return null;
                }
            }
        });
        BYTE_ARRAY_BASE_OFFSET = theUnsafe != null ? theUnsafe.arrayBaseOffset(byte[].class) : -1;
    }
}

