/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class MockRegionServerServices
implements RegionServerServices {
    protected static final Log LOG = LogFactory.getLog(MockRegionServerServices.class);
    private final Map<String, Region> regions = new HashMap<String, Region>();
    private final ConcurrentSkipListMap<byte[], Boolean> rit = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private HFileSystem hfs = null;
    private final Configuration conf;
    private ZooKeeperWatcher zkw = null;
    private ServerName serverName = null;
    private RpcServerInterface rpcServer = null;
    private volatile boolean abortRequested;
    private volatile boolean stopping = false;
    private final AtomicBoolean running = new AtomicBoolean(true);

    MockRegionServerServices(ZooKeeperWatcher zkw) {
        this(zkw, null);
    }

    MockRegionServerServices(ZooKeeperWatcher zkw, ServerName serverName) {
        this.zkw = zkw;
        this.serverName = serverName;
        this.conf = zkw == null ? new Configuration() : zkw.getConfiguration();
    }

    MockRegionServerServices() {
        this(null, null);
    }

    public MockRegionServerServices(Configuration conf) {
        this.conf = conf;
    }

    public boolean removeFromOnlineRegions(Region r, ServerName destination) {
        return this.regions.remove(r.getRegionInfo().getEncodedName()) != null;
    }

    public Region getFromOnlineRegions(String encodedRegionName) {
        return this.regions.get(encodedRegionName);
    }

    public List<Region> getOnlineRegions(TableName tableName) throws IOException {
        return null;
    }

    public Set<TableName> getOnlineTables() {
        return null;
    }

    public List<Region> getOnlineRegions() {
        return null;
    }

    public void addToOnlineRegions(Region r) {
        this.regions.put(r.getRegionInfo().getEncodedName(), r);
    }

    public void postOpenDeployTasks(Region r) throws KeeperException, IOException {
        this.addToOnlineRegions(r);
    }

    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws KeeperException, IOException {
        this.addToOnlineRegions(context.getRegion());
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public RpcServerInterface getRpcServer() {
        return this.rpcServer;
    }

    public void setRpcServer(RpcServerInterface rpc) {
        this.rpcServer = rpc;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.rit;
    }

    public FlushRequester getFlushRequester() {
        return null;
    }

    public CompactionRequestor getCompactionRequester() {
        return null;
    }

    public ClusterConnection getConnection() {
        return null;
    }

    public MetaTableLocator getMetaTableLocator() {
        return null;
    }

    public ZooKeeperWatcher getZooKeeper() {
        return this.zkw;
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    public TableLockManager getTableLockManager() {
        return new TableLockManager.NullTableLockManager();
    }

    public RegionServerQuotaManager getRegionServerQuotaManager() {
        return null;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void abort(String why, Throwable e) {
        this.abortRequested = true;
        this.stop(why);
    }

    public void stop(String why) {
        this.stopping = true;
        if (this.running.compareAndSet(true, false)) {
            LOG.info((Object)("Shutting down due to request '" + why + "'"));
        }
    }

    public boolean isStopped() {
        return !this.running.get();
    }

    public boolean isAborted() {
        return this.abortRequested;
    }

    public HFileSystem getFileSystem() {
        return this.hfs;
    }

    public void setFileSystem(FileSystem hfs) {
        this.hfs = (HFileSystem)hfs;
    }

    public Leases getLeases() {
        return null;
    }

    public WAL getWAL(HRegionInfo regionInfo) throws IOException {
        return null;
    }

    public ExecutorService getExecutorService() {
        return null;
    }

    public ChoreService getChoreService() {
        return null;
    }

    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    public Map<String, Region> getRecoveringRegions() {
        return null;
    }

    public ServerNonceManager getNonceManager() {
        return null;
    }

    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
        return false;
    }

    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo ... hris) {
        return false;
    }

    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return false;
    }

    public boolean registerService(Service service) {
        return false;
    }

    public HeapMemoryManager getHeapMemoryManager() {
        return null;
    }

    public double getCompactionPressure() {
        return 0.0;
    }

    public ThroughputController getFlushThroughputController() {
        return null;
    }

    public double getFlushPressure() {
        return 0.0;
    }

    public MetricsRegionServer getMetrics() {
        return null;
    }
}

