/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationAdmin {
    private static final Log LOG = LogFactory.getLog(TestReplicationAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";
    private static ReplicationAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        admin = new ReplicationAdmin(conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (admin != null) {
            admin.close();
        }
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        try {
            admin.addPeer("1", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("1-2", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("lock", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.removePeer("2");
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("2", "127.0.0.1:2181:/hbase2");
        }
        catch (IllegalStateException iae) {
            Assert.fail();
        }
        Assert.assertEquals((long)2L, (long)admin.getPeersCount());
        admin.removePeer("1");
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        admin.removePeer("2");
        Assert.assertEquals((long)0L, (long)admin.getPeersCount());
    }

    @Test
    public void testAddPeerWithUnDeletedQueues() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "Test HBaseAdmin", null);
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)zkw, (Configuration)conf, null);
        repQueues.init("server1");
        repQueues.addLog("1", "file1");
        try {
            admin.addPeer("1", "127.0.0.1:2181:/hbase");
            Assert.fail();
        }
        catch (ReplicationException e) {
            // empty catch block
        }
        repQueues.removeQueue("1");
        Assert.assertEquals((long)0L, (long)repQueues.getAllQueues().size());
        repQueues.addLog("1-server2", "file1");
        try {
            admin.addPeer("1", "127.0.0.1:2181:/hbase");
            Assert.fail();
        }
        catch (ReplicationException e) {
            // empty catch block
        }
        repQueues.removeAllQueues();
        zkw.close();
    }

    @Test
    public void testPeerConfig() throws Exception {
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key1", "value1");
        config.getConfiguration().put("key2", "value2");
        admin.addPeer("1", config, null);
        List peers = admin.listReplicationPeers();
        Assert.assertEquals((long)1L, (long)peers.size());
        ReplicationPeer peerOne = (ReplicationPeer)peers.get(0);
        Assert.assertNotNull((Object)peerOne);
        Assert.assertEquals((Object)"value1", (Object)peerOne.getConfiguration().get("key1"));
        Assert.assertEquals((Object)"value2", (Object)peerOne.getConfiguration().get("key2"));
        admin.removePeer("1");
    }

    @Test
    public void testEnableDisable() throws Exception {
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        Assert.assertTrue((boolean)admin.getPeerState("1"));
        admin.disablePeer("1");
        Assert.assertFalse((boolean)admin.getPeerState("1"));
        try {
            admin.getPeerState("2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        admin.removePeer("1");
    }

    @Test
    public void testGetTableCfsStr() {
        TreeMap<TableName, ArrayList> tabCFsMap = null;
        Assert.assertEquals(null, (Object)ReplicationAdmin.getTableCfsStr(tabCFsMap));
        tabCFsMap = new TreeMap<TableName, ArrayList>();
        tabCFsMap.put(TableName.valueOf((String)"tab1"), null);
        Assert.assertEquals((Object)"tab1", (Object)ReplicationAdmin.getTableCfsStr(tabCFsMap));
        tabCFsMap = new TreeMap();
        tabCFsMap.put(TableName.valueOf((String)"tab1"), Lists.newArrayList((Object[])new String[]{"cf1"}));
        Assert.assertEquals((Object)"tab1:cf1", (Object)ReplicationAdmin.getTableCfsStr(tabCFsMap));
        tabCFsMap = new TreeMap();
        tabCFsMap.put(TableName.valueOf((String)"tab1"), Lists.newArrayList((Object[])new String[]{"cf1", "cf3"}));
        Assert.assertEquals((Object)"tab1:cf1,cf3", (Object)ReplicationAdmin.getTableCfsStr(tabCFsMap));
        tabCFsMap = new TreeMap();
        tabCFsMap.put(TableName.valueOf((String)"tab1"), null);
        tabCFsMap.put(TableName.valueOf((String)"tab2"), Lists.newArrayList((Object[])new String[]{"cf1"}));
        tabCFsMap.put(TableName.valueOf((String)"tab3"), Lists.newArrayList((Object[])new String[]{"cf1", "cf3"}));
        Assert.assertEquals((Object)"tab1;tab2:cf1;tab3:cf1,cf3", (Object)ReplicationAdmin.getTableCfsStr(tabCFsMap));
    }

    @Test
    public void testAppendPeerTableCFs() throws Exception {
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        admin.appendPeerTableCFs("1", "t1");
        Assert.assertEquals((Object)"t1", (Object)admin.getPeerTableCFs("1"));
        admin.appendPeerTableCFs("1", "t2");
        String peerTablesOne = admin.getPeerTableCFs("1");
        Assert.assertTrue((String)"Should contain t1", (boolean)peerTablesOne.contains("t1"));
        Assert.assertTrue((String)"Should contain t2", (boolean)peerTablesOne.contains("t2"));
        Assert.assertTrue((String)"Should contain ; as the seperator", (boolean)peerTablesOne.contains(";"));
        admin.appendPeerTableCFs("1", "t3:f1");
        String peerTablesTwo = admin.getPeerTableCFs("1");
        Assert.assertTrue((String)"Should contain t1", (boolean)peerTablesTwo.contains("t1"));
        Assert.assertTrue((String)"Should contain t2", (boolean)peerTablesTwo.contains("t2"));
        Assert.assertTrue((String)"Should contain t3:f1", (boolean)peerTablesTwo.contains("t3:f1"));
        Assert.assertTrue((String)"Should contain ; as the seperator", (boolean)peerTablesTwo.contains(";"));
        admin.removePeer("1");
    }

    @Test
    public void testRemovePeerTableCFs() throws Exception {
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        try {
            admin.removePeerTableCFs("1", "t3");
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)"", (Object)admin.getPeerTableCFs("1"));
        admin.setPeerTableCFs("1", "t1;t2:cf1");
        try {
            admin.removePeerTableCFs("1", "t3");
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)"t1;t2:cf1", (Object)admin.getPeerTableCFs("1"));
        try {
            admin.removePeerTableCFs("1", "t1:f1");
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException e) {
            // empty catch block
        }
        admin.removePeerTableCFs("1", "t1");
        Assert.assertEquals((Object)"t2:cf1", (Object)admin.getPeerTableCFs("1"));
        try {
            admin.removePeerTableCFs("1", "t2");
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        admin.removePeerTableCFs("1", "t2:cf1");
        Assert.assertEquals((Object)"", (Object)admin.getPeerTableCFs("1"));
        admin.removePeer("1");
    }
}

