/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFileIOEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileIOEngine() throws IOException {
        long totalCapacity = 0x600000L;
        String[] filePaths = new String[]{"testFileIOEngine1", "testFileIOEngine2", "testFileIOEngine3"};
        long sizePerFile = totalCapacity / (long)filePaths.length;
        ArrayList<Long> boundaryStartPositions = new ArrayList<Long>();
        boundaryStartPositions.add(0L);
        for (int i = 1; i < filePaths.length; ++i) {
            boundaryStartPositions.add(sizePerFile * (long)i - 1L);
            boundaryStartPositions.add(sizePerFile * (long)i);
            boundaryStartPositions.add(sizePerFile * (long)i + 1L);
        }
        ArrayList<Long> boundaryStopPositions = new ArrayList<Long>();
        for (int i = 1; i < filePaths.length; ++i) {
            boundaryStopPositions.add(sizePerFile * (long)i - 1L);
            boundaryStopPositions.add(sizePerFile * (long)i);
            boundaryStopPositions.add(sizePerFile * (long)i + 1L);
        }
        boundaryStopPositions.add(sizePerFile * (long)filePaths.length - 1L);
        FileIOEngine fileIOEngine = new FileIOEngine(totalCapacity, filePaths);
        try {
            for (int i = 0; i < 500; ++i) {
                int len = (int)Math.floor(Math.random() * 100.0);
                long offset = (long)Math.floor(Math.random() * (double)totalCapacity % (double)(totalCapacity - (long)len));
                if (i < boundaryStartPositions.size()) {
                    offset = (Long)boundaryStartPositions.get(i);
                } else if (i - boundaryStartPositions.size() < boundaryStopPositions.size()) {
                    offset = (Long)boundaryStopPositions.get(i - boundaryStartPositions.size()) - (long)len + 1L;
                } else if (i % 2 == 0) {
                    offset = (long)Math.max(1, i % filePaths.length) * sizePerFile - (long)(len / 2);
                }
                byte[] data1 = new byte[len];
                for (int j = 0; j < data1.length; ++j) {
                    data1[j] = (byte)(Math.random() * 255.0);
                }
                byte[] data2 = new byte[len];
                fileIOEngine.write(ByteBuffer.wrap(data1), offset);
                fileIOEngine.read(ByteBuffer.wrap(data2), offset);
                for (int j = 0; j < data1.length; ++j) {
                    Assert.assertTrue((data1[j] == data2[j] ? 1 : 0) != 0);
                }
            }
        }
        finally {
            fileIOEngine.shutdown();
            for (String filePath : filePaths) {
                File file = new File(filePath);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }
}

