/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.regionserver.AbstractTestDateTieredCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDateTieredCompactionPolicy
extends AbstractTestDateTieredCompactionPolicy {
    @Override
    protected void config() {
        super.config();
        this.conf.set("hbase.hstore.engine.class", "org.apache.hadoop.hbase.regionserver.DateTieredStoreEngine");
        this.conf.setLong("hbase.hstore.compaction.date.tiered.max.storefile.age.millis", 100L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.incoming.window.min", 3L);
        this.conf.setLong("hbase.hstore.compaction.date.tiered.base.window.millis", 6L);
        this.conf.setInt("hbase.hstore.compaction.date.tiered.windows.per.tier", 4);
        this.conf.setBoolean("hbase.hstore.compaction.date.tiered.single.output.for.minor.compaction", false);
        this.conf.setInt("hbase.hstore.compaction.min", 2);
        this.conf.setInt("hbase.hstore.compaction.max", 12);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.2f);
        this.conf.setInt("hbase.hstore.blockingStoreFiles", 20);
        this.conf.setLong("hbase.hregion.majorcompaction", 5L);
    }

    @Test
    public void incomingWindow() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L, 12L, 13L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{10L, 11L, 12L, 13L}, new long[]{Long.MIN_VALUE, 12L}, false, true);
    }

    @Test
    public void NotIncomingWindow() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{20L, 21L, 22L, 23L, 24L, 25L}, new long[]{Long.MIN_VALUE, 6L}, false, true);
    }

    @Test
    public void OnUpperBoundOfIncomingWindow() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 18L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L, 12L, 13L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{10L, 11L, 12L, 13L}, new long[]{Long.MIN_VALUE, 12L}, false, true);
    }

    @Test
    public void NewerThanIncomingWindow() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 19L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 23L, 24L, 25L, 10L, 11L, 12L, 13L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{10L, 11L, 12L, 13L}, new long[]{Long.MIN_VALUE, 12L}, false, true);
    }

    @Test
    public void NoT2() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{44L, 60L, 61L, 97L, 100L, 193L};
        long[] sizes = new long[]{0L, 20L, 21L, 22L, 23L, 1L};
        this.compactEquals(194L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{22L, 23L}, new long[]{Long.MIN_VALUE, 96L}, false, true);
    }

    @Test
    public void T1() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{44L, 60L, 61L, 96L, 100L, 104L, 120L, 124L, 143L, 145L, 157L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 30L, 31L, 32L, 2L, 1L};
        this.compactEquals(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{30L, 31L, 32L}, new long[]{Long.MIN_VALUE, 120L}, false, true);
    }

    @Test
    public void RatioT0() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 20L, 21L, 22L, 280L, 23L, 24L, 1L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{20L, 21L, 22L}, new long[]{Long.MIN_VALUE}, false, true);
    }

    @Test
    public void RatioT2() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{44L, 60L, 61L, 96L, 100L, 104L, 120L, 124L, 143L, 145L, 157L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 350L, 30L, 31L, 2L, 1L};
        this.compactEquals(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{30L, 31L}, new long[]{Long.MIN_VALUE}, false, true);
    }

    @Test
    public void RatioT0Next() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{1L, 2L, 3L, 4L, 5L, 8L, 9L, 10L, 11L, 12L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 22L, 280L, 23L, 24L, 1L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{23L, 24L}, new long[]{Long.MIN_VALUE}, false, true);
    }

    @Test
    public void olderThanMaxAge() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{44L, 60L, 61L, 96L, 100L, 104L, 105L, 106L, 113L, 145L, 157L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L};
        this.compactEquals(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{40L, 41L, 42L, 33L, 30L, 31L}, new long[]{Long.MIN_VALUE, 96L}, false, true);
    }

    @Test
    public void outOfOrder() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{0L, 13L, 3L, 10L, 11L, 1L, 2L, 12L, 14L, 15L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 22L, 28L, 23L, 24L, 1L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{31L, 32L, 33L, 34L, 22L, 28L, 23L, 24L, 1L}, new long[]{Long.MIN_VALUE, 12L}, false, true);
    }

    @Test
    public void negativeEpochtime() throws IOException {
        long[] minTimestamps = new long[]{-1000L, -1000L, -1000L, -1000L, -1000L, -1000L, -1000L, -1000L, -1000L, -1000L};
        long[] maxTimestamps = new long[]{-28L, -11L, -10L, -9L, -8L, -7L, -6L, -5L, -4L, -3L};
        long[] sizes = new long[]{30L, 31L, 32L, 33L, 34L, 22L, 25L, 23L, 24L, 1L};
        this.compactEquals(1L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{31L, 32L, 33L, 34L, 22L, 25L, 23L, 24L, 1L}, new long[]{Long.MIN_VALUE, -24L}, false, true);
    }

    @Test
    public void majorCompation() throws IOException {
        long[] minTimestamps = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long[] maxTimestamps = new long[]{44L, 60L, 61L, 96L, 100L, 104L, 105L, 106L, 113L, 145L, 157L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L};
        this.compactEquals(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L}, new long[]{Long.MIN_VALUE, 24L, 48L, 72L, 96L, 120L, 144L, 150L, 156L}, true, true);
    }

    @Test
    public void checkMinMaxTimestampSameBoundary() throws IOException {
        long[] minTimestamps = new long[]{0L, 26L, 50L, 90L, 98L, 122L, 145L, 151L, 158L, 166L};
        long[] maxTimestamps = new long[]{12L, 46L, 70L, 95L, 100L, 140L, 148L, 155L, 162L, 174L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L};
        this.compactEquals(161L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L}, new long[]{Long.MIN_VALUE, 24L, 48L, 72L, 96L, 120L, 144L, 150L, 156L}, true, true);
    }

    @Test
    public void negativeForMajor() throws IOException {
        long[] minTimestamps = new long[]{-155L, -100L, -100L, -100L, -100L, -100L, -100L, -100L, -100L, -100L, -100L};
        long[] maxTimestamps = new long[]{-8L, -7L, -6L, -5L, -4L, -3L, -2L, -1L, 0L, 6L, 13L};
        long[] sizes = new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L};
        this.compactEquals(16L, this.sfCreate(minTimestamps, maxTimestamps, sizes), new long[]{0L, 50L, 51L, 40L, 41L, 42L, 33L, 30L, 31L, 2L, 1L}, new long[]{Long.MIN_VALUE, -144L, -120L, -96L, -72L, -48L, -24L, 0L, 6L, 12L}, true, true);
    }
}

