/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestRegionOpen {
    private static final Log LOG = LogFactory.getLog(TestRegionOpen.class);
    private static final int NB_SERVERS = 1;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    final TableName tableName = TableName.valueOf((String)TestRegionOpen.class.getSimpleName());

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    private static HRegionServer getRS() {
        return HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
    }

    @Test(timeout=60000L)
    public void testPriorityRegionIsOpenedWithSeparateThreadPool() throws Exception {
        ThreadPoolExecutor exec = TestRegionOpen.getRS().getExecutorService().getExecutorThreadPool(ExecutorType.RS_OPEN_PRIORITY_REGION);
        Assert.assertEquals((long)1L, (long)exec.getCompletedTaskCount());
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        htd.setPriority(200);
        htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable(htd);
        }
        Assert.assertEquals((long)2L, (long)exec.getCompletedTaskCount());
    }
}

