/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTimeRangeTracker {
    @Test
    public void testExtreme() {
        TimeRange tr = new TimeRange();
        Assert.assertTrue((boolean)tr.includesTimeRange(new TimeRange()));
        TimeRangeTracker trt = new TimeRangeTracker();
        Assert.assertFalse((boolean)trt.includesTimeRange(new TimeRange()));
        trt.includeTimestamp(1L);
        trt.includeTimestamp(10L);
        Assert.assertTrue((boolean)trt.includesTimeRange(new TimeRange()));
    }

    @Test
    public void testTimeRangeInitialized() {
        TimeRangeTracker src = new TimeRangeTracker();
        TimeRange tr = new TimeRange(System.currentTimeMillis());
        Assert.assertFalse((boolean)src.includesTimeRange(tr));
    }

    @Test
    public void testTimeRangeTrackerNullIsSameAsTimeRangeNull() throws IOException {
        TimeRangeTracker src = new TimeRangeTracker(1L, 2L);
        byte[] bytes = Writables.getBytes((Writable)src);
        TimeRange tgt = TimeRangeTracker.getTimeRange((byte[])bytes);
        Assert.assertEquals((long)src.getMin(), (long)tgt.getMin());
        Assert.assertEquals((long)src.getMax(), (long)tgt.getMax());
    }

    @Test
    public void testSerialization() throws IOException {
        TimeRangeTracker src = new TimeRangeTracker(1L, 2L);
        TimeRangeTracker tgt = new TimeRangeTracker();
        Writables.copyWritable((Writable)src, (Writable)tgt);
        Assert.assertEquals((long)src.getMin(), (long)tgt.getMin());
        Assert.assertEquals((long)src.getMax(), (long)tgt.getMax());
    }

    @Test
    public void testAlwaysDecrementingSetsMaximum() {
        TimeRangeTracker trr = new TimeRangeTracker();
        trr.includeTimestamp(3L);
        trr.includeTimestamp(2L);
        trr.includeTimestamp(1L);
        Assert.assertTrue((trr.getMin() != Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMax() != -1L ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleInRange() {
        TimeRangeTracker trr = new TimeRangeTracker();
        trr.includeTimestamp(0L);
        trr.includeTimestamp(2L);
        Assert.assertTrue((boolean)trr.includesTimeRange(new TimeRange(1L)));
    }

    @Test
    public void testArriveAtRightAnswer() throws InterruptedException {
        int i;
        final TimeRangeTracker trr = new TimeRangeTracker();
        int threadCount = 10;
        int calls = 1000000;
        Thread[] threads = new Thread[10];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    boolean even;
                    int offset = Integer.parseInt(this.getName());
                    boolean bl = even = offset % 2 == 0;
                    if (even) {
                        for (int i = offset * 1000000; i < 1000000; ++i) {
                            trr.includeTimestamp((long)i);
                        }
                    } else {
                        int base = offset * 1000000;
                        for (int i = base + 1000000; i >= base; --i) {
                            trr.includeTimestamp((long)i);
                        }
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((trr.getMax() == 10000000L ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMin() == 0L ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        long start = System.currentTimeMillis();
        final TimeRangeTracker trr = new TimeRangeTracker();
        int threadCount = 5;
        int calls = 0x8000000;
        Thread[] threads = new Thread[5];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    for (int i = 0; i < 0x8000000; ++i) {
                        trr.includeTimestamp((long)i);
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        System.out.println(trr.getMin() + " " + trr.getMax() + " " + (System.currentTimeMillis() - start));
    }
}

