/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummy;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestReplicationSourceManager {
    private static final Log LOG = LogFactory.getLog(TestReplicationSourceManager.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private static Replication replication;
    private static ReplicationSourceManager manager;
    private static ZooKeeperWatcher zkw;
    private static HTableDescriptor htd;
    private static HRegionInfo hri;
    private static final byte[] r1;
    private static final byte[] r2;
    private static final byte[] f1;
    private static final byte[] f2;
    private static final TableName test;
    private static final String slaveId = "1";
    private static FileSystem fs;
    private static Path oldLogDir;
    private static Path logDir;
    private static CountDownLatch latch;
    private static List<String> files;
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = HBaseConfiguration.create();
        conf.set("replication.replicationsource.implementation", ReplicationSourceDummy.class.getCanonicalName());
        conf.setBoolean("hbase.replication", true);
        conf.setLong("replication.sleep.before.failover", 2000L);
        conf.setInt("replication.source.maxretriesmultiplier", 10);
        utility = new HBaseTestingUtility(conf);
        utility.startMiniZKCluster();
        zkw = new ZooKeeperWatcher(conf, "test", null);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication");
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1", (byte[])Bytes.toBytes((String)(conf.get("hbase.zookeeper.quorum") + ":" + conf.get("hbase.zookeeper.property.clientPort") + ":/1")));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state", (byte[])ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/state");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/state", (byte[])ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
        ZKClusterId.setClusterId((ZooKeeperWatcher)zkw, (ClusterId)new ClusterId());
        FSUtils.setRootDir((Configuration)utility.getConfiguration(), (Path)utility.getDataTestDir());
        fs = FileSystem.get((Configuration)conf);
        oldLogDir = new Path(utility.getDataTestDir(), "oldWALs");
        logDir = new Path(utility.getDataTestDir(), "WALs");
        replication = new Replication((Server)new DummyServer(), fs, logDir, oldLogDir);
        manager = replication.getReplicationManager();
        manager.addSource(slaveId);
        htd = new HTableDescriptor(test);
        HColumnDescriptor col = new HColumnDescriptor(f1);
        col.setScope(1);
        htd.addFamily(col);
        col = new HColumnDescriptor(f2);
        col.setScope(0);
        htd.addFamily(col);
        hri = new HRegionInfo(htd.getTableName(), r1, r2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        manager.join();
        utility.shutdownMiniCluster();
    }

    private void cleanLogDir() throws IOException {
        fs.delete(logDir, true);
        fs.delete(oldLogDir, true);
    }

    @Before
    public void setUp() throws Exception {
        LOG.info((Object)("Start " + this.testName.getMethodName()));
        this.cleanLogDir();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info((Object)("End " + this.testName.getMethodName()));
        this.cleanLogDir();
    }

    @Test
    public void testLogRoll() throws Exception {
        long baseline;
        long time = baseline = 1000L;
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        KeyValue kv = new KeyValue(r1, f1, r1);
        WALEdit edit = new WALEdit();
        edit.add((Cell)kv);
        ArrayList<Replication> listeners = new ArrayList<Replication>();
        listeners.add(replication);
        WALFactory wals = new WALFactory(utility.getConfiguration(), listeners, URLEncoder.encode("regionserver:60020", "UTF8"));
        WAL wal = wals.getWAL(hri.getEncodedNameAsBytes(), hri.getTable().getNamespace());
        manager.init();
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor(f1));
        for (long i = 1L; i < 101L; ++i) {
            if (i > 1L && i % 20L == 0L) {
                wal.rollWriter();
            }
            LOG.info((Object)i);
            long txid = wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc), edit, true);
            wal.sync(txid);
        }
        LOG.info((Object)(baseline + " and " + time));
        time = baseline += 101L;
        LOG.info((Object)(baseline + " and " + time));
        for (int i = 0; i < 3; ++i) {
            wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc), edit, true);
        }
        wal.sync();
        int logNumber = 0;
        for (Map.Entry entry : ((Map)manager.getWALs().get(slaveId)).entrySet()) {
            logNumber += ((SortedSet)entry.getValue()).size();
        }
        Assert.assertEquals((long)6L, (long)logNumber);
        wal.rollWriter();
        manager.logPositionAndCleanOldLogs(((ReplicationSourceInterface)manager.getSources().get(0)).getCurrentPath(), slaveId, 0L, false, false);
        wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc), edit, true);
        wal.sync();
        Assert.assertEquals((long)1L, (long)manager.getWALs().size());
    }

    @Test
    public void testClaimQueues() throws Exception {
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        DummyServer server = new DummyServer("hostname0.example.org");
        ReplicationQueues rq = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration(), (Abortable)server);
        rq.init(server.getServerName().toString());
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            rq.addLog(slaveId, file);
        }
        DummyServer s1 = new DummyServer("dummyserver1.example.org");
        DummyServer s2 = new DummyServer("dummyserver2.example.org");
        DummyServer s3 = new DummyServer("dummyserver3.example.org");
        DummyNodeFailoverWorker w1 = new DummyNodeFailoverWorker(server.getServerName().getServerName(), s1);
        DummyNodeFailoverWorker w2 = new DummyNodeFailoverWorker(server.getServerName().getServerName(), s2);
        DummyNodeFailoverWorker w3 = new DummyNodeFailoverWorker(server.getServerName().getServerName(), s3);
        latch = new CountDownLatch(3);
        w1.start();
        w2.start();
        w3.start();
        int populatedMap = 0;
        latch.await();
        Assert.assertEquals((long)1L, (long)(populatedMap += w1.isLogZnodesMapPopulated() + w2.isLogZnodesMapPopulated() + w3.isLogZnodesMapPopulated()));
        server.abort("", null);
    }

    @Test
    public void testCleanupFailoverQueues() throws Exception {
        DummyServer server = new DummyServer("hostname1.example.org");
        ReplicationQueues rq = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration(), (Abortable)server);
        rq.init(server.getServerName().toString());
        TreeSet<String> files = new TreeSet<String>();
        String group = "testgroup";
        String file1 = group + ".log1";
        String file2 = group + ".log2";
        files.add(file1);
        files.add(file2);
        for (String file : files) {
            rq.addLog(slaveId, file);
        }
        DummyServer s1 = new DummyServer("dummyserver1.example.org");
        ReplicationQueues rq1 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)s1.getZooKeeper(), (Configuration)s1.getConfiguration(), (Abortable)s1);
        rq1.init(s1.getServerName().toString());
        ReplicationPeers rp1 = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)s1.getZooKeeper(), (Configuration)s1.getConfiguration(), (Abortable)s1);
        rp1.init();
        ReplicationSourceManager replicationSourceManager = manager;
        replicationSourceManager.getClass();
        ReplicationSourceManager.NodeFailoverWorker w1 = new ReplicationSourceManager.NodeFailoverWorker(replicationSourceManager, server.getServerName().getServerName(), rq1, rp1, new UUID(new Long(1L), new Long(2L)));
        w1.start();
        w1.join(10000L);
        Assert.assertEquals((long)1L, (long)manager.getWalsByIdRecoveredQueues().size());
        String id = "1-" + server.getServerName().getServerName();
        Assert.assertEquals(files, ((Map)manager.getWalsByIdRecoveredQueues().get(id)).get(group));
        manager.cleanOldLogs(file2, id, true);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{file2}), ((Map)manager.getWalsByIdRecoveredQueues().get(id)).get(group));
    }

    @Test
    public void testNodeFailoverDeadServerParsing() throws Exception {
        LOG.debug((Object)"testNodeFailoverDeadServerParsing");
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        DummyServer server = new DummyServer("ec2-54-234-230-108.compute-1.amazonaws.com");
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)conf, (Abortable)server);
        repQueues.init(server.getServerName().toString());
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            repQueues.addLog(slaveId, file);
        }
        DummyServer s1 = new DummyServer("ip-10-8-101-114.ec2.internal");
        DummyServer s2 = new DummyServer("ec2-107-20-52-47.compute-1.amazonaws.com");
        DummyServer s3 = new DummyServer("ec2-23-20-187-167.compute-1.amazonaws.com");
        ReplicationQueues rq1 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)s1.getZooKeeper(), (Configuration)s1.getConfiguration(), (Abortable)s1);
        rq1.init(s1.getServerName().toString());
        String serverName = server.getServerName().getServerName();
        List unclaimed = rq1.getUnClaimedQueueIds(serverName);
        rq1.claimQueue(serverName, (String)unclaimed.get(0)).getSecond();
        rq1.removeReplicatorIfQueueIsEmpty((String)unclaimed.get(0));
        ReplicationQueues rq2 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)s2.getZooKeeper(), (Configuration)s2.getConfiguration(), (Abortable)s2);
        rq2.init(s2.getServerName().toString());
        serverName = s1.getServerName().getServerName();
        unclaimed = rq2.getUnClaimedQueueIds(serverName);
        rq2.claimQueue(serverName, (String)unclaimed.get(0)).getSecond();
        rq2.removeReplicatorIfQueueIsEmpty((String)unclaimed.get(0));
        ReplicationQueues rq3 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)s3.getZooKeeper(), (Configuration)s3.getConfiguration(), (Abortable)s3);
        rq3.init(s3.getServerName().toString());
        serverName = s2.getServerName().getServerName();
        unclaimed = rq3.getUnClaimedQueueIds(serverName);
        String queue3 = (String)rq3.claimQueue(serverName, (String)unclaimed.get(0)).getFirst();
        rq3.removeReplicatorIfQueueIsEmpty((String)unclaimed.get(0));
        ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(queue3);
        List result = replicationQueueInfo.getDeadRegionServers();
        Assert.assertTrue((boolean)result.contains(server.getServerName().getServerName()));
        Assert.assertTrue((boolean)result.contains(s1.getServerName().getServerName()));
        Assert.assertTrue((boolean)result.contains(s2.getServerName().getServerName()));
        server.abort("", null);
    }

    @Test
    public void testFailoverDeadServerCversionChange() throws Exception {
        LOG.debug((Object)"testFailoverDeadServerCversionChange");
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        DummyServer s0 = new DummyServer("cversion-change0.example.org");
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)s0.getZooKeeper(), (Configuration)conf, (Abortable)s0);
        repQueues.init(s0.getServerName().toString());
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            repQueues.addLog(slaveId, file);
        }
        DummyServer s1 = new DummyServer("cversion-change1.example.org");
        ReplicationQueues rq1 = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)s1.getZooKeeper(), (Configuration)s1.getConfiguration(), (Abortable)s1);
        rq1.init(s1.getServerName().toString());
        ReplicationQueuesClient client = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)s1.getZooKeeper(), (Configuration)s1.getConfiguration(), (Abortable)s1);
        int v0 = client.getQueuesZNodeCversion();
        List queues = rq1.getUnClaimedQueueIds(s0.getServerName().getServerName());
        for (String queue : queues) {
            rq1.claimQueue(s0.getServerName().getServerName(), queue);
        }
        rq1.removeReplicatorIfQueueIsEmpty(s0.getServerName().getServerName());
        int v1 = client.getQueuesZNodeCversion();
        Assert.assertEquals((long)(v0 + 1), (long)v1);
        s0.abort("", null);
    }

    @Test
    public void testCleanupUnknownPeerZNode() throws Exception {
        DummyServer server = new DummyServer("hostname2.example.org");
        ReplicationQueues rq = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration(), (Abortable)server);
        rq.init(server.getServerName().toString());
        String group = "testgroup";
        rq.addLog("2", group + ".log1");
        rq.addLog("2", group + ".log2");
        ReplicationSourceManager replicationSourceManager = manager;
        replicationSourceManager.getClass();
        ReplicationSourceManager.NodeFailoverWorker w1 = new ReplicationSourceManager.NodeFailoverWorker(replicationSourceManager, server.getServerName().getServerName());
        w1.run();
        for (String peer : manager.getAllQueues()) {
            Assert.assertTrue((boolean)peer.startsWith(slaveId));
        }
    }

    @Test
    public void testBulkLoadWALEditsWithoutBulkLoadReplicationEnabled() throws Exception {
        WALKey logKey = new WALKey();
        WALEdit logEdit = this.getBulkLoadWALEdit();
        Replication.scopeWALEdits((HTableDescriptor)htd, (WALKey)logKey, (WALEdit)logEdit, (Configuration)conf, (ReplicationSourceManager)manager);
        Assert.assertNull((String)"No bulk load entries scope should be added if bulk load replication is diabled.", (Object)logKey.getScopes());
    }

    @Test
    public void testBulkLoadWALEdits() throws Exception {
        WALKey logKey = new WALKey();
        WALEdit logEdit = this.getBulkLoadWALEdit();
        Configuration bulkLoadConf = HBaseConfiguration.create((Configuration)conf);
        bulkLoadConf.setBoolean("hbase.replication.bulkload.enabled", true);
        Replication.scopeWALEdits((HTableDescriptor)htd, (WALKey)logKey, (WALEdit)logEdit, (Configuration)bulkLoadConf, (ReplicationSourceManager)manager);
        NavigableMap scopes = logKey.getScopes();
        Assert.assertTrue((String)"This family scope is set to global, should be part of replication key scopes.", (boolean)scopes.containsKey(f1));
        Assert.assertFalse((String)"This family scope is set to local, should not be part of replication key scopes", (boolean)scopes.containsKey(f2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerRemovalCleanup() throws Exception {
        String replicationSourceImplName = conf.get("replication.replicationsource.implementation");
        try {
            DummyServer server = new DummyServer();
            final ReplicationQueues rq = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)server.getConfiguration(), (Abortable)server);
            rq.init(server.getServerName().toString());
            conf.set("replication.replicationsource.implementation", FailInitializeDummyReplicationSource.class.getName());
            final ReplicationPeers rp = manager.getReplicationPeers();
            rp.addPeer("FakePeer", new ReplicationPeerConfig().setClusterKey("localhost:1:/hbase"), null);
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return rp.getPeer("FakePeer") != null;
                }
            });
            List sources = manager.getSources();
            for (ReplicationSourceInterface source : sources) {
                Assert.assertNotEquals((Object)"FakePeer", (Object)source.getPeerClusterId());
            }
            manager.removePeer("FakePeer");
            Assert.assertFalse((boolean)rq.getAllQueues().contains("FakePeer"));
            Assert.assertNull((Object)rp.getPeer("FakePeer"));
            rp.removePeer("FakePeer");
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    List peers = rp.getAllPeerIds();
                    return !rq.getAllQueues().contains("FakePeer") && rp.getPeer("FakePeer") == null && !peers.contains("FakePeer");
                }
            });
        }
        finally {
            conf.set("replication.replicationsource.implementation", replicationSourceImplName);
        }
    }

    private WALEdit getBulkLoadWALEdit() {
        HashMap storeFiles = new HashMap(1);
        HashMap<String, Long> storeFilesSize = new HashMap<String, Long>(1);
        ArrayList<Path> p = new ArrayList<Path>(1);
        Path hfilePath1 = new Path(Bytes.toString((byte[])f1));
        p.add(hfilePath1);
        try {
            storeFilesSize.put(hfilePath1.getName(), fs.getFileStatus(hfilePath1).getLen());
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to calculate the size of hfile " + hfilePath1));
            storeFilesSize.put(hfilePath1.getName(), 0L);
        }
        storeFiles.put(f1, p);
        p = new ArrayList(1);
        Path hfilePath2 = new Path(Bytes.toString((byte[])f2));
        p.add(hfilePath2);
        try {
            storeFilesSize.put(hfilePath2.getName(), fs.getFileStatus(hfilePath2).getLen());
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to calculate the size of hfile " + hfilePath2));
            storeFilesSize.put(hfilePath2.getName(), 0L);
        }
        storeFiles.put(f2, p);
        WALProtos.BulkLoadDescriptor desc = ProtobufUtil.toBulkLoadDescriptor((TableName)hri.getTable(), (ByteString)ByteStringer.wrap((byte[])hri.getEncodedNameAsBytes()), storeFiles, storeFilesSize, (long)1L);
        WALEdit logEdit = WALEdit.createBulkLoadEvent((HRegionInfo)hri, (WALProtos.BulkLoadDescriptor)desc);
        return logEdit;
    }

    static {
        r1 = Bytes.toBytes((String)"r1");
        r2 = Bytes.toBytes((String)"r2");
        f1 = Bytes.toBytes((String)"f1");
        f2 = Bytes.toBytes((String)"f2");
        test = TableName.valueOf((String)"test");
        files = new ArrayList<String>();
    }

    static class DummyServer
    implements Server {
        String hostname;

        DummyServer() {
            this.hostname = "hostname.example.org";
        }

        DummyServer(String hostname) {
            this.hostname = hostname;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return zkw;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.hostname, (int)1234, (long)1L);
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }
    }

    static class FailInitializeDummyReplicationSource
    extends ReplicationSourceDummy {
        FailInitializeDummyReplicationSource() {
        }

        @Override
        public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueues rq, ReplicationPeers rp, Stoppable stopper, String peerClusterId, UUID clusterId, ReplicationEndpoint replicationEndpoint, MetricsSource metrics) throws IOException {
            throw new IOException("Failing deliberately");
        }
    }

    static class DummyNodeFailoverWorker
    extends Thread {
        private SortedMap<String, SortedSet<String>> logZnodesMap;
        Server server;
        private String deadRsZnode;
        ReplicationQueues rq;

        public DummyNodeFailoverWorker(String znode, Server s) throws Exception {
            this.deadRsZnode = znode;
            this.server = s;
            this.rq = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)this.server.getZooKeeper(), (Configuration)this.server.getConfiguration(), (Abortable)this.server);
            this.rq.init(this.server.getServerName().toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.logZnodesMap = new TreeMap<String, SortedSet<String>>();
                List queues = this.rq.getUnClaimedQueueIds(this.deadRsZnode);
                for (String queue : queues) {
                    Pair pair = this.rq.claimQueue(this.deadRsZnode, queue);
                    this.logZnodesMap.put((String)pair.getFirst(), (SortedSet<String>)pair.getSecond());
                }
                this.server.abort("Done with testing", null);
            }
            catch (Exception e) {
                LOG.error((Object)"Got exception while running NodeFailoverWorker", (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        }

        private int isLogZnodesMapPopulated() {
            Collection<SortedSet<String>> sets = this.logZnodesMap.values();
            if (sets.size() > 1) {
                throw new RuntimeException("unexpected size of logZnodesMap: " + sets.size());
            }
            if (sets.size() == 1) {
                SortedSet<String> s = sets.iterator().next();
                for (String file : files) {
                    if (s.contains(file)) continue;
                    return 0;
                }
                return 1;
            }
            return 0;
        }
    }
}

