/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.cratedb;

import io.edurt.datacap.plugin.jdbc.cratedb.CrateDBAdapter;
import io.edurt.datacap.plugin.jdbc.cratedb.CrateDBConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrateDBPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(CrateDBPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection connection;
    private Response response;

    public String name() {
        return "CrateDB";
    }

    public String description() {
        return "Integrate CrateDB data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("io.crate.client.jdbc.CrateDriver");
            this.jdbcConfigure.setJdbcType("crate");
            this.connection = new CrateDBConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute cratedb plugin logic started");
            this.response = this.connection.getResponse();
            CrateDBAdapter processor = new CrateDBAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute cratedb plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

