/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.Closeable;
import java.util.concurrent.ExecutionException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.CloseableUtils;
import org.apache.omid.TestUtils;
import org.apache.omid.tso.HALeaseManagementModule;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.VoidLeaseManagementModule;
import org.apache.omid.tso.client.ConnectionException;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.statemachine.StateMachine;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTSOClientConnectionToTSO {
    private static final Logger LOG = LoggerFactory.getLogger(TestTSOClientConnectionToTSO.class);
    private static final String TSO_HOST = "localhost";
    private static final String CURRENT_TSO_PATH = "/current_tso_path";
    private static final String TSO_LEASE_PATH = "/tso_lease_path";
    private int tsoPortForTest;
    private String zkClusterForTest;
    private Injector injector = null;
    private TestingServer zkServer;
    private CuratorFramework zkClient;
    private TSOServer tsoServer;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.tsoPortForTest = TestUtils.getFreeLocalPort();
        int zkPortForTest = TestUtils.getFreeLocalPort();
        this.zkClusterForTest = "localhost:" + zkPortForTest;
        LOG.info("Starting ZK Server in port {}", (Object)zkPortForTest);
        this.zkServer = TestUtils.provideTestingZKServer(zkPortForTest);
        LOG.info("ZK Server Started @ {}", (Object)this.zkServer.getConnectString());
        this.zkClient = TestUtils.provideConnectedZKClient(this.zkClusterForTest);
        try {
            this.zkClient.delete().forPath(CURRENT_TSO_PATH);
            Stat stat = (Stat)this.zkClient.checkExists().forPath(CURRENT_TSO_PATH);
            Assert.assertNull((Object)stat, (String)"/current_tso_path should not exist");
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info("{} ZNode did not exist", (Object)CURRENT_TSO_PATH);
        }
    }

    @AfterMethod
    public void afterMethod() {
        this.zkClient.close();
        CloseableUtils.closeQuietly((Closeable)this.zkServer);
        this.zkServer = null;
        LOG.info("ZK Server Stopped");
    }

    @Test(timeOut=30000L)
    public void testUnsuccessfulConnectionToTSO() throws Exception {
        try {
            TSOClient.newInstance((OmidClientConfiguration)new OmidClientConfiguration());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeOut=30000L)
    public void testSuccessfulConnectionToTSOWithHostAndPort() throws Exception {
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setConflictMapSize(1000);
        tsoConfig.setPort(this.tsoPortForTest);
        tsoConfig.setTimestampType(TSOServerConfig.TIMESTAMP_TYPE.INCREMENTAL.toString());
        tsoConfig.setLeaseModule((Module)new VoidLeaseManagementModule());
        this.injector = Guice.createInjector((Module[])new Module[]{new TSOMockModule(tsoConfig)});
        LOG.info("Starting TSO");
        this.tsoServer = (TSOServer)this.injector.getInstance(TSOServer.class);
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_HOST, this.tsoPortForTest, 100);
        LOG.info("Finished loading TSO");
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:" + this.tsoPortForTest);
        tsoClientConf.setZkCurrentTsoPath(CURRENT_TSO_PATH);
        TSOClient tsoClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
        Long startTS = (Long)tsoClient.getNewStartTimestamp().get();
        LOG.info("Start TS {} ", (Object)startTS);
        Assert.assertEquals((long)startTS, (long)50L);
        tsoClient.close().get();
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_HOST, this.tsoPortForTest, 1000);
        LOG.info("TSO Server Stopped");
    }

    @Test(timeOut=30000L)
    public void testSuccessfulConnectionToTSOThroughZK() throws Exception {
        TSOServerConfig config = new TSOServerConfig();
        config.setConflictMapSize(1000);
        config.setPort(this.tsoPortForTest);
        config.setLeaseModule((Module)new HALeaseManagementModule(1000L, TSO_LEASE_PATH, CURRENT_TSO_PATH, this.zkClusterForTest, "omid"));
        this.injector = Guice.createInjector((Module[])new Module[]{new TSOMockModule(config)});
        LOG.info("Starting TSO");
        this.tsoServer = (TSOServer)this.injector.getInstance(TSOServer.class);
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_HOST, this.tsoPortForTest, 100);
        LOG.info("Finished loading TSO");
        this.waitTillTsoRegisters((CuratorFramework)this.injector.getInstance(CuratorFramework.class));
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionType(OmidClientConfiguration.ConnType.HA);
        tsoClientConf.setConnectionString(this.zkClusterForTest);
        tsoClientConf.setZkCurrentTsoPath(CURRENT_TSO_PATH);
        TSOClient tsoClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
        Long startTS = (Long)tsoClient.getNewStartTimestamp().get();
        LOG.info("Start TS {} ", (Object)startTS);
        Assert.assertTrue((startTS >= 50L ? 1 : 0) != 0);
        tsoClient.close().get();
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_HOST, this.tsoPortForTest, 1000);
        LOG.info("TSO Server Stopped");
    }

    @Test(timeOut=30000L)
    public void testSuccessOfTSOClientReconnectionsToARestartedTSOWithZKPublishing() throws Exception {
        TSOServerConfig config = new TSOServerConfig();
        config.setConflictMapSize(1000);
        config.setPort(this.tsoPortForTest);
        config.setLeaseModule((Module)new HALeaseManagementModule(1000L, TSO_LEASE_PATH, CURRENT_TSO_PATH, this.zkClusterForTest, "omid"));
        this.injector = Guice.createInjector((Module[])new Module[]{new TSOMockModule(config)});
        LOG.info("Starting Initial TSO");
        this.tsoServer = (TSOServer)this.injector.getInstance(TSOServer.class);
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_HOST, this.tsoPortForTest, 100);
        LOG.info("Finished loading TSO");
        this.waitTillTsoRegisters((CuratorFramework)this.injector.getInstance(CuratorFramework.class));
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionType(OmidClientConfiguration.ConnType.HA);
        tsoClientConf.setConnectionString(this.zkClusterForTest);
        tsoClientConf.setZkCurrentTsoPath(CURRENT_TSO_PATH);
        TSOClient tsoClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
        Long startTS = (Long)tsoClient.getNewStartTimestamp().get();
        LOG.info("Start TS {} ", (Object)startTS);
        Assert.assertTrue((startTS >= 50L ? 1 : 0) != 0);
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_HOST, this.tsoPortForTest, 1000);
        LOG.info("Initial TSO Server Stopped");
        Thread.sleep(1500L);
        try {
            startTS = (Long)tsoClient.getNewStartTimestamp().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            LOG.info("Exception expected");
            StateMachine.FsmImpl fsm = (StateMachine.FsmImpl)tsoClient.fsm;
            Assert.assertEquals(e.getCause().getClass(), ConnectionException.class);
            Assert.assertTrue((fsm.getState().getClass().equals(TSOClient.ConnectionFailedState.class) || fsm.getState().getClass().equals(TSOClient.DisconnectedState.class) ? 1 : 0) != 0);
        }
        Injector newInjector = Guice.createInjector((Module[])new Module[]{new TSOMockModule(config)});
        LOG.info("Re-Starting again the TSO");
        this.tsoServer = (TSOServer)newInjector.getInstance(TSOServer.class);
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_HOST, this.tsoPortForTest, 100);
        LOG.info("Finished loading restarted TSO");
        boolean reconnectionActive = false;
        while (!reconnectionActive) {
            try {
                startTS = (Long)tsoClient.getNewStartTimestamp().get();
                reconnectionActive = true;
            }
            catch (ExecutionException executionException) {}
        }
        Assert.assertNotNull((Object)startTS);
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        TestUtils.waitForSocketNotListening(TSO_HOST, this.tsoPortForTest, 1000);
        LOG.info("Restarted TSO Server Stopped");
    }

    private void waitTillTsoRegisters(CuratorFramework zkClient) throws Exception {
        while (true) {
            try {
                while (true) {
                    Stat stat;
                    if ((stat = (Stat)zkClient.checkExists().forPath(CURRENT_TSO_PATH)) == null) {
                        continue;
                    }
                    LOG.info("TSO registered in HA with path {}={}", (Object)CURRENT_TSO_PATH, (Object)stat.toString());
                    if (stat.toString().length() != 0) break;
                }
                return;
            }
            catch (Exception e) {
                LOG.debug("TSO still has not registered yet, sleeping...", (Throwable)e);
                Thread.sleep(500L);
                continue;
            }
            break;
        }
    }
}

