/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.monetdb;

import io.edurt.datacap.plugin.jdbc.monetdb.MonetDBAdapter;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonetDBPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(MonetDBPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection connection;
    private Response response;

    public String name() {
        return "MonetDB";
    }

    public String description() {
        return "Integrate MonetDB data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("org.monetdb.jdbc.MonetDriver");
            this.jdbcConfigure.setJdbcType("monetdb");
            this.connection = new JdbcConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute monetdb plugin logic started");
            this.response = this.connection.getResponse();
            MonetDBAdapter processor = new MonetDBAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute monetdb plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

