/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc;

import com.itmuch.redis.jdbc.Logger;
import com.itmuch.redis.jdbc.RedisClient;
import com.itmuch.redis.jdbc.RedisConnection;
import com.itmuch.redis.jdbc.RedisResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class RedisStatement
implements Statement {
    private static final Logger LOGGER = new Logger(RedisStatement.class);
    private final RedisConnection connection;
    private final RedisClient redisClient;
    private ResultSet resultSet;
    private boolean isClosed = false;
    private int fetchSize = 1;

    public RedisStatement(RedisConnection connection, RedisClient redisClient) {
        this.connection = connection;
        this.redisClient = redisClient;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        LOGGER.log("executeQuery(%s)", sql);
        this.checkClosed();
        String[] result = this.redisClient.sendCommand(sql);
        return new RedisResultSet(result, this);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        String[] result = this.redisClient.sendCommand(sql);
        return result.length;
    }

    @Override
    public void close() throws SQLException {
        LOGGER.log("close()", new Object[0]);
        if (this.isClosed) {
            LOGGER.log("Statement has been closed.", new Object[0]);
            return;
        }
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            this.resultSet.close();
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return Integer.MAX_VALUE;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        LOGGER.log("setQueryTimeout..", new Object[0]);
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancel not implemented");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        LOGGER.log("getWarnings returns null", new Object[0]);
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        LOGGER.log("setCursorName not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("setCursorName not implemented");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        String[] result = this.redisClient.sendCommand(sql);
        this.resultSet = new RedisResultSet(result, this);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        LOGGER.log("getUpdateCount()", new Object[0]);
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        LOGGER.log("getMoreResults()", new Object[0]);
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        LOGGER.log("setFetchDirection not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("setFetchDirection not implemented");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        LOGGER.log("addBatch not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("addBatch not implemented");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        LOGGER.log("clearBatch not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("addBatch not implemented");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        LOGGER.log("executeBatch not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("executeBatch not implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        LOGGER.log("getMoreResults(%s)", current);
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        LOGGER.log("getGeneratedKeys not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("getGeneratedKeys not implemented");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeUpdate(sql);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 0);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 0);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeUpdate(sql);
        return true;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 0);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 0);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        LOGGER.log("Statement isClosed = %s", this.isClosed);
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        LOGGER.log("setPoolable not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("setPoolable not implemented");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        LOGGER.log("closeOnCompletion not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("closeOnCompletion not implemented");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        LOGGER.log("isCloseOnCompletion not implemented", new Object[0]);
        return false;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            LOGGER.log("Statement is closed.", new Object[0]);
            throw new SQLException("Statement is closed.");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            LOGGER.log("Unable to unwrap to %s", iface);
            throw new SQLException("Unable to unwrap to " + iface);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

