/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.conf;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.InputPropertiesValidator;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfTreeOperations {
    public final ConfTree confTree;
    private final MapOperations globalOptions;
    protected static final Logger log = LoggerFactory.getLogger(ConfTreeOperations.class);

    public ConfTreeOperations(ConfTree confTree) {
        assert (confTree != null) : "null tree";
        assert (confTree.components != null) : "null tree components";
        this.confTree = confTree;
        this.globalOptions = new MapOperations("global", confTree.global);
    }

    public ConfTree getConfTree() {
        return this.confTree;
    }

    public void validate() throws BadConfigException {
        this.validate(null);
    }

    public void validate(InputPropertiesValidator validator) throws BadConfigException {
        String version = this.confTree.schema;
        if (version == null) {
            throw new BadConfigException("'version' undefined");
        }
        if (!"http://example.org/specification/v2.0.0".equals(version)) {
            throw new BadConfigException("version %s incompatible with supported version %s", version, "http://example.org/specification/v2.0.0");
        }
        if (validator != null) {
            validator.validate(this);
        }
    }

    public void resolve() {
        for (Map.Entry<String, Map<String, String>> comp : this.confTree.components.entrySet()) {
            this.mergeInGlobal(comp.getValue());
        }
    }

    public void mergeInGlobal(Map<String, String> component) {
        SliderUtils.mergeMapsIgnoreDuplicateKeys(component, this.confTree.global);
    }

    public MapOperations getGlobalOptions() {
        return this.globalOptions;
    }

    public MapOperations getComponent(String component) {
        Map<String, String> instance = this.confTree.components.get(component);
        if (instance != null) {
            return new MapOperations(component, instance);
        }
        return null;
    }

    public Map<String, Map<String, String>> getComponents() {
        return this.confTree.components;
    }

    public MapOperations getOrAddComponent(String name) {
        MapOperations operations = this.getComponent(name);
        if (operations != null) {
            return operations;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        this.confTree.components.put(name, map);
        return new MapOperations(name, map);
    }

    @JsonIgnore
    public Set<String> getComponentNames() {
        return new HashSet<String>(this.confTree.components.keySet());
    }

    public MapOperations getMandatoryComponent(String name) throws BadConfigException {
        MapOperations ops = this.getComponent(name);
        if (ops == null) {
            throw new BadConfigException("Missing component " + name);
        }
        return ops;
    }

    public void set(String key, Object value) {
        this.globalOptions.put(key, value.toString());
    }

    public String get(String key) {
        return this.globalOptions.get(key);
    }

    public void propagateGlobalKeys(ConfTree src, String prefix) {
        Map<String, String> global = src.global;
        for (Map.Entry<String, String> entry : global.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            this.set(key, entry.getValue());
        }
    }

    public void propagateGlobalKeys(ConfTreeOperations src, String prefix) {
        this.propagateGlobalKeys(src.confTree, prefix);
    }

    public void mergeSingleComponentMap(String component, Map<String, String> map) {
        MapOperations comp = this.getOrAddComponent(component);
        comp.putAll((Map<? extends String, ? extends String>)map);
    }

    public void mergeSingleComponentMapPrefix(String component, Map<String, String> map, String prefix, boolean overwrite) {
        MapOperations comp = this.getOrAddComponent(component);
        comp.mergeMapPrefixedKeys(map, prefix, overwrite);
    }

    public void mergeComponents(Map<String, Map<String, String>> commandOptions) {
        for (Map.Entry<String, Map<String, String>> entry : commandOptions.entrySet()) {
            this.mergeSingleComponentMap(entry.getKey(), entry.getValue());
        }
    }

    public void mergeComponentsPrefix(Map<String, Map<String, String>> commandOptions, String prefix, boolean overwrite) {
        for (Map.Entry<String, Map<String, String>> entry : commandOptions.entrySet()) {
            this.mergeSingleComponentMapPrefix(entry.getKey(), entry.getValue(), prefix, overwrite);
        }
    }

    public void mergeWithoutOverwrite(ConfTree that) {
        this.getGlobalOptions().mergeWithoutOverwrite(that.global);
        this.confTree.metadata.putAll(that.metadata);
        this.confTree.credentials.putAll(that.credentials);
        for (Map.Entry<String, Map<String, String>> entry : that.components.entrySet()) {
            MapOperations comp = this.getOrAddComponent(entry.getKey());
            comp.mergeWithoutOverwrite(entry.getValue());
        }
    }

    public void merge(ConfTree that) {
        this.getGlobalOptions().putAll((Map<? extends String, ? extends String>)that.global);
        this.confTree.metadata.putAll(that.metadata);
        this.confTree.credentials.putAll(that.credentials);
        for (Map.Entry<String, Map<String, String>> entry : that.components.entrySet()) {
            MapOperations comp = this.getOrAddComponent(entry.getKey());
            comp.putAll((Map<? extends String, ? extends String>)entry.getValue());
        }
    }

    public static ConfTreeOperations fromResource(String resource) throws IOException {
        ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
        ConfTreeOperations ops = new ConfTreeOperations((ConfTree)confTreeSerDeser.fromResource(resource));
        return ops;
    }

    public static ConfTreeOperations fromFile(File resource) throws IOException {
        ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
        ConfTreeOperations ops = new ConfTreeOperations((ConfTree)confTreeSerDeser.fromFile(resource));
        return ops;
    }

    public static ConfTreeOperations fromInstance(ConfTree instance) throws IOException {
        ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
        ConfTreeOperations ops = new ConfTreeOperations((ConfTree)confTreeSerDeser.fromJson(confTreeSerDeser.toJson(instance)));
        return ops;
    }

    public void mergeFile(File file) throws IOException, BadConfigException {
        this.mergeFile(file, null);
    }

    public void mergeFile(File file, InputPropertiesValidator validator) throws IOException, BadConfigException {
        ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
        ConfTree tree = (ConfTree)confTreeSerDeser.fromFile(file);
        ConfTreeOperations ops = new ConfTreeOperations(tree);
        ops.validate(validator);
        this.merge(ops.confTree);
    }

    public String toString() {
        return this.confTree.toString();
    }

    public String toJson() throws IOException, JsonGenerationException, JsonMappingException {
        return this.confTree.toJson();
    }

    public String getComponentOpt(String name, String option, String defVal) {
        MapOperations roleopts = this.getComponent(name);
        if (roleopts == null) {
            return defVal;
        }
        return roleopts.getOption(option, defVal);
    }

    public int getComponentOptInt(String name, String option, int defVal) {
        String val = this.getComponentOpt(name, option, Integer.toString(defVal));
        return Integer.decode(val);
    }

    public void setComponentOpt(String component, String option, String val) {
        MapOperations roleopts = this.getOrAddComponent(component);
        roleopts.put(option, val);
    }

    public void setComponentOpt(String role, String option, int val) {
        this.setComponentOpt(role, option, Integer.toString(val));
    }

    public void setComponentOpt(String role, String option, long val) {
        this.setComponentOpt(role, option, Long.toString(val));
    }
}

