/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.slider.api.types.SliderInstanceDescription;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnAppListClient {
    private final SliderYarnClientImpl yarnClient;
    private final String username;
    private final Configuration conf;
    private static final Logger log = LoggerFactory.getLogger(YarnAppListClient.class);

    public YarnAppListClient(SliderYarnClientImpl yarnClient, String username, Configuration conf) {
        Preconditions.checkArgument((yarnClient != null ? 1 : 0) != 0, (Object)"yarn client is null: is app inited?");
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username is null");
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"conf parameter is null");
        this.yarnClient = yarnClient;
        this.username = username;
        this.conf = conf;
    }

    public List<ApplicationReport> findAllLiveInstances(String appname) throws YarnException, IOException {
        return this.yarnClient.findAllLiveInstances(this.username, appname);
    }

    public ApplicationReport findInstance(String appname) throws YarnException, IOException {
        List<ApplicationReport> instances = this.listInstances(null);
        return this.yarnClient.findClusterInInstanceList(instances, appname);
    }

    public List<ApplicationReport> listInstances() throws YarnException, IOException {
        return this.listInstances(null);
    }

    public List<ApplicationReport> listInstances(String user) throws YarnException, IOException {
        String listUser = user == null ? this.username : user;
        return this.yarnClient.listDeployedInstances(listUser);
    }

    public Map<String, SliderInstanceDescription> enumSliderInstances(boolean listOnlyInState, YarnApplicationState minAppState, YarnApplicationState maxAppState) throws IOException, YarnException {
        CoreFileSystem sliderFileSystem = new CoreFileSystem(this.conf);
        Preconditions.checkArgument((!listOnlyInState || minAppState != null ? 1 : 0) != 0, (Object)"null minAppState when listOnlyInState set");
        Preconditions.checkArgument((!listOnlyInState || maxAppState != null ? 1 : 0) != 0, (Object)"null maxAppState when listOnlyInState set");
        if (!listOnlyInState) {
            minAppState = YarnApplicationState.NEW;
            maxAppState = YarnApplicationState.KILLED;
        }
        Map<String, Path> persistentInstances = sliderFileSystem.listPersistentInstances();
        HashMap<String, SliderInstanceDescription> descriptions = new HashMap<String, SliderInstanceDescription>(persistentInstances.size());
        if (persistentInstances.isEmpty()) {
            log.debug("No application instances found");
            return descriptions;
        }
        List<ApplicationReport> rmInstances = this.listInstances();
        SliderUtils.sortApplicationsByMostRecent(rmInstances);
        Map<String, ApplicationReport> reportMap = SliderUtils.buildApplicationReportMap(rmInstances, minAppState, maxAppState);
        log.debug("Persisted {} deployed {} filtered[{}-{}] & de-duped to {}", new Object[]{persistentInstances.size(), rmInstances.size(), minAppState, maxAppState, reportMap.size()});
        for (Map.Entry<String, Path> entry : persistentInstances.entrySet()) {
            String name = entry.getKey();
            ApplicationReport report = reportMap.get(name);
            if (listOnlyInState && report == null) continue;
            SliderInstanceDescription sid = new SliderInstanceDescription(name, entry.getValue(), report);
            descriptions.put(name, sid);
        }
        return descriptions;
    }
}

