/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.io.IOUtils;
import org.apache.slider.server.services.workflow.LongLivedProcessLifecycleEvent;
import org.apache.slider.server.services.workflow.ServiceThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongLivedProcess
implements Runnable {
    public static final int RECENT_LINE_LOG_LIMIT = 64;
    private static final int STREAM_READER_SLEEP_TIME = 200;
    private static final int LINE_LENGTH = 256;
    private final ProcessBuilder processBuilder;
    private Process process;
    private Integer exitCode = null;
    private final String name;
    private final ExecutorService processExecutor;
    private final ExecutorService logExecutor;
    private ProcessStreamReader processStreamReader;
    private final List<String> recentLines = new LinkedList<String>();
    private int recentLineLimit = 64;
    private LongLivedProcessLifecycleEvent lifecycleCallback;
    private final AtomicBoolean finalOutputProcessed = new AtomicBoolean(false);
    private Logger processLog;
    private static final Logger LOG = LoggerFactory.getLogger(LongLivedProcess.class);
    private final AtomicBoolean finished = new AtomicBoolean(false);

    public LongLivedProcess(String name, Logger processLog, List<String> commands) {
        Preconditions.checkArgument((commands != null ? 1 : 0) != 0, (Object)"commands");
        this.name = name;
        this.processLog = processLog;
        ServiceThreadFactory factory = new ServiceThreadFactory(name, true);
        this.processExecutor = Executors.newSingleThreadExecutor(factory);
        this.logExecutor = Executors.newSingleThreadExecutor(factory);
        this.processBuilder = new ProcessBuilder(commands);
        this.processBuilder.redirectErrorStream(false);
    }

    public void setRecentLineLimit(int recentLineLimit) {
        this.recentLineLimit = recentLineLimit;
    }

    public void setLifecycleCallback(LongLivedProcessLifecycleEvent lifecycleCallback) {
        this.lifecycleCallback = lifecycleCallback;
    }

    public void setEnv(String envVar, String val) {
        Preconditions.checkArgument((envVar != null ? 1 : 0) != 0, (Object)"envVar");
        Preconditions.checkArgument((val != null ? 1 : 0) != 0, (Object)"val");
        this.processBuilder.environment().put(envVar, val);
    }

    public void putEnvMap(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String val = entry.getValue();
            String key = entry.getKey();
            this.setEnv(key, val);
        }
    }

    public String getEnv(String variable) {
        return this.processBuilder.environment().get(variable);
    }

    public void setProcessLog(Logger processLog) {
        this.processLog = processLog;
    }

    public Process getProcess() {
        return this.process;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public List<String> getCommands() {
        return this.processBuilder.command();
    }

    public String getCommand() {
        return this.getCommands().get(0);
    }

    public boolean isRunning() {
        return this.process != null && !this.finished.get();
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public Integer getExitCodeSignCorrected() {
        Integer result = this.exitCode != null ? Integer.valueOf(this.exitCode << 24 >> 24) : null;
        return result;
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.process.destroy();
    }

    protected String describeBuilder() {
        StringBuilder buffer = new StringBuilder();
        for (String arg : this.processBuilder.command()) {
            buffer.append('\"').append(arg).append("\" ");
        }
        return buffer.toString();
    }

    public void dumpEnv(StringBuilder buffer) {
        buffer.append("\nEnvironment\n-----------");
        Map<String, String> env = this.processBuilder.environment();
        Set<String> keys = env.keySet();
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            buffer.append(key).append("=").append(env.get(key)).append('\n');
        }
    }

    private Process spawnChildProcess() throws IOException {
        if (this.process != null) {
            throw new IOException("Process already started");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Spawning process:\n " + this.describeBuilder());
        }
        try {
            this.process = this.processBuilder.start();
        }
        catch (IOException e) {
            if (e.toString().contains("CreateProcess error=2")) {
                FileNotFoundException fnfe = new FileNotFoundException(e.toString());
                fnfe.initCause(e);
                throw fnfe;
            }
            throw e;
        }
        return this.process;
    }

    @Override
    public void run() {
        block15: {
            Preconditions.checkNotNull((Object)this.process, (Object)"null process");
            LOG.debug("Lifecycle callback thread running");
            if (this.lifecycleCallback != null) {
                this.lifecycleCallback.onProcessStarted(this);
            }
            try {
                try {
                    IOUtils.closeStream((Closeable)this.process.getOutputStream());
                    this.exitCode = this.process.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.debug("Process wait interrupted -exiting thread", (Throwable)e);
                    LOG.debug("process {} has finished", (Object)this.name);
                    this.finished.set(true);
                    this.logExecutor.shutdown();
                    try {
                        this.logExecutor.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.lifecycleCallback != null) {
                        this.lifecycleCallback.onProcessExited(this, this.exitCode, this.getExitCodeSignCorrected());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                LOG.debug("process {} has finished", (Object)this.name);
                this.finished.set(true);
                this.logExecutor.shutdown();
                try {
                    this.logExecutor.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
                if (this.lifecycleCallback != null) {
                    this.lifecycleCallback.onProcessExited(this, this.exitCode, this.getExitCodeSignCorrected());
                }
                throw throwable;
            }
            LOG.debug("process {} has finished", (Object)this.name);
            this.finished.set(true);
            this.logExecutor.shutdown();
            try {
                this.logExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
            if (this.lifecycleCallback != null) {
                this.lifecycleCallback.onProcessExited(this, this.exitCode, this.getExitCodeSignCorrected());
            }
        }
    }

    public void start() throws IOException {
        this.spawnChildProcess();
        this.processStreamReader = new ProcessStreamReader(this.processLog, 200);
        this.logExecutor.submit(this.processStreamReader);
        this.processExecutor.submit(this);
    }

    public synchronized List<String> getRecentOutput() {
        return new ArrayList<String>(this.recentLines);
    }

    public synchronized boolean isRecentOutputEmpty() {
        return this.recentLines.isEmpty();
    }

    public boolean isFinalOutputProcessed() {
        return this.finalOutputProcessed.get();
    }

    public List<String> getRecentOutput(boolean finalOutput, int duration) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= (long)duration) {
            boolean finishedOutput;
            if (finalOutput) {
                finishedOutput = this.isFinalOutputProcessed();
            } else {
                boolean bl = finishedOutput = !this.isRecentOutputEmpty();
            }
            if (finishedOutput) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return this.getRecentOutput();
    }

    private synchronized void recordRecentLine(String line, boolean isErrorStream, Logger logger) {
        if (line == null) {
            return;
        }
        String entry = String.valueOf(isErrorStream ? "[ERR] " : "[OUT] ") + line;
        this.recentLines.add(entry);
        if (this.recentLines.size() > this.recentLineLimit) {
            this.recentLines.remove(0);
        }
        if (logger != null) {
            if (isErrorStream) {
                logger.warn(line);
            } else {
                logger.info(line);
            }
        }
    }

    private class ProcessStreamReader
    implements Runnable {
        private final Logger streamLog;
        private final int sleepTime;

        private ProcessStreamReader(Logger streamLog, int sleepTime) {
            this.streamLog = streamLog;
            this.sleepTime = sleepTime;
        }

        private int readCharNonBlocking(BufferedReader reader) throws IOException {
            if (reader.ready()) {
                return reader.read();
            }
            return -1;
        }

        private boolean readAnyLine(BufferedReader reader, StringBuilder line, int limit) throws IOException {
            int next;
            while (-1 != (next = this.readCharNonBlocking(reader))) {
                if (next != 10) {
                    line.append((char)next);
                    if (line.length() <= --limit) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            block10: {
                BufferedReader errReader = null;
                BufferedReader outReader = null;
                StringBuilder outLine = new StringBuilder(256);
                StringBuilder errorLine = new StringBuilder(256);
                try {
                    try {
                        errReader = new BufferedReader(new InputStreamReader(LongLivedProcess.this.process.getErrorStream()));
                        outReader = new BufferedReader(new InputStreamReader(LongLivedProcess.this.process.getInputStream()));
                        while (!LongLivedProcess.this.finished.get()) {
                            boolean processed = false;
                            if (this.readAnyLine(errReader, errorLine, 256)) {
                                LongLivedProcess.this.recordRecentLine(errorLine.toString(), true, this.streamLog);
                                errorLine.setLength(0);
                                processed = true;
                            }
                            if (this.readAnyLine(outReader, outLine, 256)) {
                                LongLivedProcess.this.recordRecentLine(outLine.toString(), false, this.streamLog);
                                outLine.setLength(0);
                                processed |= true;
                            }
                            if (processed || LongLivedProcess.this.finished.get()) continue;
                            try {
                                Thread.sleep(this.sleepTime);
                            }
                            catch (InterruptedException e) {
                                LOG.debug("Ignoring ", (Throwable)e);
                            }
                        }
                        this.recordFinalOutput(errReader, errorLine, true, this.streamLog);
                        this.recordFinalOutput(outReader, outLine, false, this.streamLog);
                    }
                    catch (Exception ignored) {
                        LOG.warn("encountered {}", (Object)ignored, (Object)ignored);
                        IOUtils.closeStream(errReader);
                        IOUtils.closeStream(outReader);
                        LongLivedProcess.this.finalOutputProcessed.set(true);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(errReader);
                    IOUtils.closeStream(outReader);
                    LongLivedProcess.this.finalOutputProcessed.set(true);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)errReader);
                IOUtils.closeStream((Closeable)outReader);
                LongLivedProcess.this.finalOutputProcessed.set(true);
            }
        }

        protected void recordFinalOutput(BufferedReader reader, StringBuilder lineBuilder, boolean isErrorStream, Logger logger) throws IOException {
            String line = lineBuilder.toString();
            LongLivedProcess.this.recordRecentLine(line, isErrorStream, logger);
            line = reader.readLine();
            while (line != null) {
                LongLivedProcess.this.recordRecentLine(line, isErrorStream, logger);
                line = reader.readLine();
                if (Thread.interrupted()) break;
            }
        }
    }
}

