/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FileContextURIBase {
    private static final String basePath = System.getProperty("test.build.data", "build/test/data") + "/testContextURI";
    private static final Path BASE = new Path(basePath);
    private static final Pattern WIN_INVALID_FILE_NAME_PATTERN = Pattern.compile("^(.*?[<>\\:\"\\|\\?\\*].*?)|(.*?[ \\.])$");
    protected FileContext fc1;
    protected FileContext fc2;

    protected Path qualifiedPath(String path, FileContext fc) {
        return fc.makeQualified(new Path(BASE, path));
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.fc2.delete(BASE, true);
    }

    @Test
    public void testCreateFile() throws IOException {
        String[] fileNames;
        for (String f : fileNames = new String[]{"testFile", "test File", "test*File", "test#File", "test1234", "1234Test", "test)File", "test_File", "()&^%$#@!~_+}{><?", "  ", "^ "}) {
            if (!FileContextURIBase.isTestableFileNameOnPlatform(f)) continue;
            Path testPath = this.qualifiedPath(f, this.fc2);
            Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            FileContextTestHelper.createFile(this.fc1, testPath);
            Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        }
    }

    @Test
    public void testCreateFileWithNullName() throws IOException {
        String fileName = null;
        try {
            Path testPath = this.qualifiedPath(fileName, this.fc2);
            Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            FileContextTestHelper.createFile(this.fc1, testPath);
            Assert.fail((String)"Create file with null name should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateExistingFile() throws IOException {
        String fileName = "testFile";
        Path testPath = this.qualifiedPath(fileName, this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        FileContextTestHelper.createFile(this.fc1, testPath);
        try {
            FileContextTestHelper.createFile(this.fc2, testPath);
            Assert.fail((String)"Create existing file should throw an IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
    }

    @Test
    public void testCreateFileInNonExistingDirectory() throws IOException {
        String fileName = "testDir/testFile";
        Path testPath = this.qualifiedPath(fileName, this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        FileContextTestHelper.createFile(this.fc1, testPath);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, testPath.getParent()));
        Assert.assertEquals((Object)"testDir", (Object)testPath.getParent().getName());
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
    }

    @Test
    public void testCreateDirectory() throws IOException {
        String[] dirNames;
        Path path = this.qualifiedPath("test/hadoop", this.fc2);
        Path falsePath = this.qualifiedPath("path/doesnot.exist", this.fc2);
        Path subDirPath = this.qualifiedPath("dir0", this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc1, path));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(this.fc1, path));
        Assert.assertFalse((boolean)FileContextTestHelper.isDir(this.fc1, path));
        this.fc1.mkdir(path, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, path));
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, path));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(this.fc2, path));
        this.fc1.mkdir(subDirPath, FsPermission.getDefault(), true);
        this.fc1.mkdir(subDirPath, FsPermission.getDefault(), true);
        this.fc1.mkdir(subDirPath, FsPermission.getDefault(), true);
        Path parentDir = path.getParent();
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, parentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(this.fc2, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, grandparentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isFile(this.fc2, grandparentDir));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, falsePath));
        Assert.assertFalse((boolean)FileContextTestHelper.isDir(this.fc2, falsePath));
        for (String f : dirNames = new String[]{"createTest/testDir", "createTest/test Dir", "deleteTest/test*Dir", "deleteTest/test#Dir", "deleteTest/test1234", "deleteTest/test_DIr", "deleteTest/1234Test", "deleteTest/test)Dir", "deleteTest/()&^%$#@!~_+}{><?", "  ", "^ "}) {
            if (!FileContextURIBase.isTestableFileNameOnPlatform(f)) continue;
            Path testPath = this.qualifiedPath(f, this.fc2);
            Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            this.fc1.mkdir(testPath, FsPermission.getDefault(), true);
            Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, testPath));
        }
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.qualifiedPath("test/hadoop", this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testDir));
        this.fc2.mkdir(testDir, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testDir));
        FileContextTestHelper.createFile(this.fc1, this.qualifiedPath("test/hadoop/file", this.fc2));
        Path testSubDir = this.qualifiedPath("test/hadoop/file/subdir", this.fc2);
        try {
            this.fc1.mkdir(testSubDir, FsPermission.getDefault(), true);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc1, testSubDir));
        Path testDeepSubDir = this.qualifiedPath("test/hadoop/file/deep/sub/dir", this.fc1);
        try {
            this.fc2.mkdir(testDeepSubDir, FsPermission.getDefault(), true);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc1, testDeepSubDir));
    }

    @Test
    public void testIsDirectory() throws IOException {
        String dirName = "dirTest";
        String invalidDir = "nonExistantDir";
        String rootDir = "/";
        Path existingPath = this.qualifiedPath(dirName, this.fc2);
        Path nonExistingPath = this.qualifiedPath(invalidDir, this.fc2);
        Path pathToRootDir = this.qualifiedPath(rootDir, this.fc2);
        this.fc1.mkdir(existingPath, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, existingPath));
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, pathToRootDir));
        Assert.assertFalse((boolean)FileContextTestHelper.isDir(this.fc2, nonExistingPath));
    }

    @Test
    public void testDeleteFile() throws IOException {
        Path testPath = this.qualifiedPath("testFile", this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        FileContextTestHelper.createFile(this.fc1, testPath);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        this.fc2.delete(testPath, false);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
    }

    @Test
    public void testDeleteNonExistingFile() throws IOException {
        String testFileName = "testFile";
        Path testPath = this.qualifiedPath(testFileName, this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertFalse((boolean)this.fc2.delete(testPath, false));
        FileContextTestHelper.createFile(this.fc1, testPath);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertTrue((boolean)this.fc2.delete(testPath, false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertFalse((boolean)this.fc2.delete(testPath, false));
    }

    @Test
    public void testDeleteNonExistingFileInDir() throws IOException {
        String testFileInDir = "testDir/testDir/TestFile";
        Path testPath = this.qualifiedPath(testFileInDir, this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertFalse((boolean)this.fc2.delete(testPath, false));
        FileContextTestHelper.createFile(this.fc1, testPath);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertTrue((boolean)this.fc2.delete(testPath, false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertFalse((boolean)this.fc2.delete(testPath, false));
    }

    @Test
    public void testDeleteDirectory() throws IOException {
        String[] dirNames;
        String dirName = "dirTest";
        Path testDirPath = this.qualifiedPath(dirName, this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testDirPath));
        this.fc1.mkdir(testDirPath, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testDirPath));
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, testDirPath));
        this.fc2.delete(testDirPath, true);
        Assert.assertFalse((boolean)FileContextTestHelper.isDir(this.fc2, testDirPath));
        for (String f : dirNames = new String[]{"deleteTest/testDir", "deleteTest/test Dir", "deleteTest/test*Dir", "deleteTest/test#Dir", "deleteTest/test1234", "deleteTest/1234Test", "deleteTest/test)Dir", "deleteTest/test_DIr", "deleteTest/()&^%$#@!~_+}{><?", "  ", "^ "}) {
            if (!FileContextURIBase.isTestableFileNameOnPlatform(f)) continue;
            Path testPath = this.qualifiedPath(f, this.fc2);
            Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            this.fc1.mkdir(testPath, FsPermission.getDefault(), true);
            Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc2, testPath));
            Assert.assertTrue((boolean)this.fc2.delete(testPath, true));
            Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
            Assert.assertFalse((boolean)FileContextTestHelper.isDir(this.fc2, testPath));
        }
    }

    @Test
    public void testDeleteNonExistingDirectory() throws IOException {
        String testDirName = "testFile";
        Path testPath = this.qualifiedPath(testDirName, this.fc2);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertFalse((boolean)this.fc2.delete(testPath, false));
        this.fc1.mkdir(testPath, FsPermission.getDefault(), true);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertTrue((boolean)this.fc2.delete(testPath, false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc2, testPath));
        Assert.assertFalse((boolean)this.fc2.delete(testPath, false));
    }

    @Test
    public void testModificationTime() throws IOException {
        String testFile = "file1";
        Path testPath = this.qualifiedPath(testFile, this.fc2);
        FileContextTestHelper.createFile(this.fc1, testPath);
        long fc1ModificationTime = this.fc1.getFileStatus(testPath).getModificationTime();
        long fc2ModificationTime = this.fc2.getFileStatus(testPath).getModificationTime();
        Assert.assertEquals((long)fc1ModificationTime, (long)fc2ModificationTime);
    }

    @Test
    public void testFileStatus() throws IOException {
        String fileName = "file1";
        Path path2 = this.fc2.makeQualified(new Path(BASE, fileName));
        FileContextTestHelper.createFile(this.fc1, path2);
        FsStatus fc2Status = this.fc2.getFsStatus(path2);
        Assert.assertNotNull((Object)fc2Status);
        Assert.assertTrue((fc2Status.getCapacity() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((fc2Status.getRemaining() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((fc2Status.getUsed() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        String testFile = "test/hadoop/fileDoesNotExist";
        Path testPath = this.qualifiedPath(testFile, this.fc2);
        try {
            this.fc1.getFileStatus(testPath);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        String testFile = "test/hadoop/file";
        Path testPath = this.qualifiedPath(testFile, this.fc2);
        try {
            this.fc1.listStatus(testPath);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatus() throws Exception {
        String hPrefix = "test/hadoop";
        String[] dirs = new String[]{"test/hadoop/a", "test/hadoop/b", "test/hadoop/c", "test/hadoop/1", "test/hadoop/#@#@", "test/hadoop/&*#$#$@234"};
        ArrayList<Path> testDirs = new ArrayList<Path>();
        for (String d : dirs) {
            if (!FileContextURIBase.isTestableFileNameOnPlatform(d)) continue;
            testDirs.add(this.qualifiedPath(d, this.fc2));
        }
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc1, (Path)testDirs.get(0)));
        for (Path path : testDirs) {
            this.fc1.mkdir(path, FsPermission.getDefault(), true);
        }
        FileStatus[] paths = this.fc1.util().listStatus(this.qualifiedPath("test", this.fc1));
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)this.qualifiedPath("test/hadoop", this.fc1), (Object)paths[0].getPath());
        paths = this.fc1.util().listStatus(this.qualifiedPath("test/hadoop", this.fc1));
        Assert.assertEquals((long)testDirs.size(), (long)paths.length);
        for (int i = 0; i < testDirs.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < paths.length; ++j) {
                if (!this.qualifiedPath(((Path)testDirs.get(i)).toString(), this.fc1).equals((Object)paths[j].getPath())) continue;
                found = true;
            }
            Assert.assertTrue((String)(testDirs.get(i) + " not found"), (boolean)found);
        }
        paths = this.fc1.util().listStatus(this.qualifiedPath(dirs[0], this.fc1));
        Assert.assertEquals((long)0L, (long)paths.length);
        RemoteIterator pathsItor = this.fc1.listStatus(this.qualifiedPath("test", this.fc1));
        Assert.assertEquals((Object)this.qualifiedPath("test/hadoop", this.fc1), (Object)((FileStatus)pathsItor.next()).getPath());
        Assert.assertFalse((boolean)pathsItor.hasNext());
        pathsItor = this.fc1.listStatus(this.qualifiedPath("test/hadoop", this.fc1));
        int dirLen = 0;
        while (pathsItor.hasNext()) {
            boolean found = false;
            FileStatus stat = (FileStatus)pathsItor.next();
            for (int j = 0; j < dirs.length; ++j) {
                if (!this.qualifiedPath(dirs[j], this.fc1).equals((Object)stat.getPath())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)(stat.getPath() + " not found"), (boolean)found);
            ++dirLen;
        }
        Assert.assertEquals((long)testDirs.size(), (long)dirLen);
        pathsItor = this.fc1.listStatus(this.qualifiedPath(dirs[0], this.fc1));
        Assert.assertFalse((boolean)pathsItor.hasNext());
    }

    private static boolean isTestableFileNameOnPlatform(String fileName) {
        boolean valid = true;
        if (Shell.WINDOWS) {
            valid = !WIN_INVALID_FILE_NAME_PATTERN.matcher(fileName).matches();
        }
        return valid;
    }
}

