/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCopyPreserveFlag {
    private static final int MODIFICATION_TIME = 12345000;
    private static final Path FROM = new Path("d1", "f1");
    private static final Path TO = new Path("d2", "f2");
    private static final FsPermission PERMISSIONS = new FsPermission(FsAction.ALL, FsAction.EXECUTE, FsAction.READ_WRITE);
    private FileSystem fs;
    private Path testDir;
    private Configuration conf;

    @Before
    public void initialize() throws Exception {
        this.conf = new Configuration(false);
        this.conf.set("fs.file.impl", LocalFileSystem.class.getName());
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new Path(System.getProperty("test.build.data", "build/test/data") + "/testStat");
        this.testDir = new Path(this.fs.makeQualified(this.testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fs.getUri());
        this.fs.setWorkingDirectory(this.testDir);
        this.fs.mkdirs(new Path("d1"));
        this.fs.mkdirs(new Path("d2"));
        this.fs.createNewFile(FROM);
        FSDataOutputStream output = this.fs.create(FROM, true);
        for (int i = 0; i < 100; ++i) {
            output.writeInt(i);
            output.writeChar(10);
        }
        output.close();
        this.fs.setTimes(FROM, 12345000L, 0L);
        this.fs.setPermission(FROM, PERMISSIONS);
        this.fs.setTimes(new Path("d1"), 12345000L, 0L);
        this.fs.setPermission(new Path("d1"), PERMISSIONS);
    }

    @After
    public void cleanup() throws Exception {
        this.fs.delete(this.testDir, true);
        this.fs.close();
    }

    private void assertAttributesPreserved() throws IOException {
        Assert.assertEquals((long)12345000L, (long)this.fs.getFileStatus(TO).getModificationTime());
        Assert.assertEquals((Object)PERMISSIONS, (Object)this.fs.getFileStatus(TO).getPermission());
    }

    private void assertAttributesChanged() throws IOException {
        Assert.assertTrue((12345000L != this.fs.getFileStatus(TO).getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((!PERMISSIONS.equals((Object)this.fs.getFileStatus(TO).getPermission()) ? 1 : 0) != 0);
    }

    private void run(CommandWithDestination cmd, String ... args) {
        cmd.setConf(this.conf);
        Assert.assertEquals((long)0L, (long)cmd.run(args));
    }

    @Test(timeout=10000L)
    public void testPutWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Put(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved();
    }

    @Test(timeout=10000L)
    public void testPutWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Put(), FROM.toString(), TO.toString());
        this.assertAttributesChanged();
    }

    @Test(timeout=10000L)
    public void testGetWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved();
    }

    @Test(timeout=10000L)
    public void testGetWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), FROM.toString(), TO.toString());
        this.assertAttributesChanged();
    }

    @Test(timeout=10000L)
    public void testCpWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved();
    }

    @Test(timeout=10000L)
    public void testCpWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), FROM.toString(), TO.toString());
        this.assertAttributesChanged();
    }

    @Test(timeout=10000L)
    public void testDirectoryCpWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "-p", "d1", "d3");
        Assert.assertEquals((long)this.fs.getFileStatus(new Path("d1")).getModificationTime(), (long)this.fs.getFileStatus(new Path("d3")).getModificationTime());
        Assert.assertEquals((Object)this.fs.getFileStatus(new Path("d1")).getPermission(), (Object)this.fs.getFileStatus(new Path("d3")).getPermission());
    }

    @Test(timeout=10000L)
    public void testDirectoryCpWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "d1", "d4");
        Assert.assertTrue((this.fs.getFileStatus(new Path("d1")).getModificationTime() != this.fs.getFileStatus(new Path("d4")).getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((!this.fs.getFileStatus(new Path("d1")).getPermission().equals((Object)this.fs.getFileStatus(new Path("d4")).getPermission()) ? 1 : 0) != 0);
    }
}

