/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.api.impl.LlapRecordReader;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.BatchToRowInputFormat;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.LlapAwareSplit;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.HiveStringUtils;

public class LlapInputFormat
implements InputFormat<NullWritable, VectorizedRowBatch>,
VectorizedInputFormatInterface,
SelfDescribingInputFormatInterface,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final String NONVECTOR_SETTING_MESSAGE = "disable " + HiveConf.ConfVars.LLAP_IO_NONVECTOR_WRAPPER_ENABLED.varname + " to work around this error";
    private final InputFormat<NullWritable, VectorizedRowBatch> sourceInputFormat;
    private final CombineHiveInputFormat.AvoidSplitCombination sourceASC;
    private final Deserializer sourceSerDe;
    final ColumnVectorProducer cvp;
    final ExecutorService executor;
    private final String hostName;

    LlapInputFormat(InputFormat sourceInputFormat, Deserializer sourceSerDe, ColumnVectorProducer cvp, ExecutorService executor) {
        this.executor = executor;
        this.cvp = cvp;
        this.sourceInputFormat = sourceInputFormat;
        this.sourceASC = sourceInputFormat instanceof CombineHiveInputFormat.AvoidSplitCombination ? (CombineHiveInputFormat.AvoidSplitCombination)sourceInputFormat : null;
        this.sourceSerDe = sourceSerDe;
        this.hostName = HiveStringUtils.getHostname();
    }

    public RecordReader<NullWritable, VectorizedRowBatch> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        RecordReader<NullWritable, VectorizedRowBatch> noLlap = this.checkLlapSplit(split, job, reporter);
        if (noLlap != null) {
            return noLlap;
        }
        FileSplit fileSplit = (FileSplit)split;
        reporter.setStatus(fileSplit.toString());
        try {
            List includedCols = ColumnProjectionUtils.isReadAllColumns((Configuration)job) ? null : ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
            RecordReader<NullWritable, VectorizedRowBatch> rr = LlapRecordReader.create(job, fileSplit, includedCols, this.hostName, this.cvp, this.executor, this.sourceInputFormat, this.sourceSerDe, reporter);
            if (rr == null) {
                return this.sourceInputFormat.getRecordReader(split, job, reporter);
            }
            RecordReader<NullWritable, VectorizedRowBatch> result = rr;
            if (!Utilities.getUseVectorizedInputFileFormat((Configuration)job) && (result = this.wrapLlapReader(includedCols, (LlapRecordReader)rr, split)) == null) {
                return this.sourceInputFormat.getRecordReader(split, job, reporter);
            }
            rr.start();
            return result;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private RecordReader<NullWritable, VectorizedRowBatch> wrapLlapReader(List<Integer> includedCols, LlapRecordReader rr, InputSplit split) throws IOException {
        if (this.sourceInputFormat instanceof BatchToRowInputFormat) {
            LlapIoImpl.LOG.info("Using batch-to-row converter for split: " + split);
            return LlapInputFormat.bogusCast(((BatchToRowInputFormat)this.sourceInputFormat).getWrapper((RecordReader)rr, rr.getVectorizedRowBatchCtx(), includedCols));
        }
        LlapIoImpl.LOG.warn("Not using LLAP IO for an unsupported split: " + split);
        return null;
    }

    public RecordReader<NullWritable, VectorizedRowBatch> checkLlapSplit(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        boolean useLlapIo = true;
        if (split instanceof LlapAwareSplit) {
            useLlapIo = ((LlapAwareSplit)split).canUseLlapIo();
        }
        if (useLlapIo) {
            return null;
        }
        LlapIoImpl.LOG.warn("Not using LLAP IO for an unsupported split: " + split);
        return this.sourceInputFormat.getRecordReader(split, job, reporter);
    }

    private static <A, B, C, D> RecordReader<A, B> bogusCast(RecordReader<C, D> rr) {
        return rr;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.sourceInputFormat.getSplits(job, numSplits);
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return this.sourceASC == null ? false : this.sourceASC.shouldSkipCombine(path, conf);
    }

    static VectorizedRowBatchCtx createFakeVrbCtx(MapWork mapWork) throws HiveException {
        LinkedHashMap partSpec;
        PartitionDesc partDesc;
        RowSchema rowSchema = LlapInputFormat.findTsOp(mapWork).getSchema();
        ArrayList<String> colNames = new ArrayList<String>(rowSchema.getSignature().size());
        ArrayList<TypeInfo> colTypes = new ArrayList<TypeInfo>(rowSchema.getSignature().size());
        for (ColumnInfo c : rowSchema.getSignature()) {
            String columnName = c.getInternalName();
            if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((Object)columnName)) continue;
            colNames.add(columnName);
            colTypes.add(TypeInfoUtils.getTypeInfoFromTypeString((String)c.getTypeName()));
        }
        int partitionColumnCount = 0;
        Iterator paths = mapWork.getPathToAliases().keySet().iterator();
        if (paths.hasNext() && (partDesc = (PartitionDesc)mapWork.getPathToPartitionInfo().get(paths.next())) != null && (partSpec = partDesc.getPartSpec()) != null && !partSpec.isEmpty()) {
            partitionColumnCount = partSpec.size();
        }
        return new VectorizedRowBatchCtx(colNames.toArray(new String[colNames.size()]), colTypes.toArray(new TypeInfo[colTypes.size()]), null, partitionColumnCount, new String[0]);
    }

    static TableScanOperator findTsOp(MapWork mapWork) throws HiveException {
        if (mapWork.getAliasToWork() == null) {
            throw new HiveException("Unexpected - aliasToWork is missing; " + NONVECTOR_SETTING_MESSAGE);
        }
        Iterator ops = mapWork.getAliasToWork().values().iterator();
        TableScanOperator tableScanOperator = null;
        while (ops.hasNext()) {
            Operator op = (Operator)ops.next();
            if (!(op instanceof TableScanOperator)) continue;
            if (tableScanOperator != null) {
                throw new HiveException("Unexpected - more than one TSOP; " + NONVECTOR_SETTING_MESSAGE);
            }
            tableScanOperator = (TableScanOperator)op;
        }
        return tableScanOperator;
    }
}

