/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ConnectionConfiguration {
    static final Log LOG = LogFactory.getLog(ConnectionConfiguration.class);
    public static final String WRITE_BUFFER_SIZE_KEY = "hbase.client.write.buffer";
    public static final long WRITE_BUFFER_SIZE_DEFAULT = 0x200000L;
    public static final String WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS = "hbase.client.write.buffer.periodicflush.timeout.ms";
    public static final String WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS = "hbase.client.write.buffer.periodicflush.timertick.ms";
    public static final long WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS_DEFAULT = 0L;
    public static final long WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS_DEFAULT = 1000L;
    public static final String MAX_KEYVALUE_SIZE_KEY = "hbase.client.keyvalue.maxsize";
    public static final int MAX_KEYVALUE_SIZE_DEFAULT = -1;
    private final long writeBufferSize;
    private final long writeBufferPeriodicFlushTimeoutMs;
    private final long writeBufferPeriodicFlushTimerTickMs;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int primaryCallTimeoutMicroSecond;
    private final int replicaCallTimeoutMicroSecondScan;
    private final int metaReplicaCallTimeoutMicroSecondScan;
    private final int retries;
    private final int maxKeyValueSize;
    private final int readRpcTimeout;
    private final int writeRpcTimeout;
    private final long pause;
    private final long pauseForCQTBE;

    ConnectionConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong(WRITE_BUFFER_SIZE_KEY, 0x200000L);
        this.writeBufferPeriodicFlushTimeoutMs = conf.getLong(WRITE_BUFFER_PERIODIC_FLUSH_TIMEOUT_MS, 0L);
        this.writeBufferPeriodicFlushTimerTickMs = conf.getLong(WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS, 1000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.primaryCallTimeoutMicroSecond = conf.getInt("hbase.client.primaryCallTimeout.get", 10000);
        this.replicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.replicaCallTimeout.scan", 1000000);
        this.metaReplicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.meta.replica.scan.timeout", 1000000);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.maxKeyValueSize = conf.getInt(MAX_KEYVALUE_SIZE_KEY, -1);
        this.readRpcTimeout = conf.getInt("hbase.rpc.read.timeout", conf.getInt("hbase.rpc.timeout", 60000));
        this.writeRpcTimeout = conf.getInt("hbase.rpc.write.timeout", conf.getInt("hbase.rpc.timeout", 60000));
        this.pause = conf.getLong("hbase.client.pause", 100L);
        long configuredPauseForCQTBE = conf.getLong("hbase.client.pause.cqtbe", this.pause);
        if (configuredPauseForCQTBE < this.pause) {
            LOG.warn((Object)("The hbase.client.pause.cqtbe setting: " + configuredPauseForCQTBE + " is smaller than " + "hbase.client.pause" + ", will use " + this.pause + " instead."));
            this.pauseForCQTBE = this.pause;
        } else {
            this.pauseForCQTBE = configuredPauseForCQTBE;
        }
    }

    @VisibleForTesting
    protected ConnectionConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.writeBufferPeriodicFlushTimeoutMs = 0L;
        this.writeBufferPeriodicFlushTimerTickMs = 1000L;
        this.metaOperationTimeout = 1200000;
        this.operationTimeout = 1200000;
        this.scannerCaching = Integer.MAX_VALUE;
        this.scannerMaxResultSize = 0x200000L;
        this.primaryCallTimeoutMicroSecond = 10000;
        this.replicaCallTimeoutMicroSecondScan = 1000000;
        this.metaReplicaCallTimeoutMicroSecondScan = 1000000;
        this.retries = 31;
        this.maxKeyValueSize = -1;
        this.readRpcTimeout = 60000;
        this.writeRpcTimeout = 60000;
        this.pause = 100L;
        this.pauseForCQTBE = 100L;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public long getWriteBufferPeriodicFlushTimeoutMs() {
        return this.writeBufferPeriodicFlushTimeoutMs;
    }

    public long getWriteBufferPeriodicFlushTimerTickMs() {
        return this.writeBufferPeriodicFlushTimerTickMs;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getPrimaryCallTimeoutMicroSecond() {
        return this.primaryCallTimeoutMicroSecond;
    }

    public int getReplicaCallTimeoutMicroSecondScan() {
        return this.replicaCallTimeoutMicroSecondScan;
    }

    public int getMetaReplicaCallTimeoutMicroSecondScan() {
        return this.metaReplicaCallTimeoutMicroSecondScan;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    public long getPause() {
        return this.pause;
    }

    public long getPauseForCQTBE() {
        return this.pauseForCQTBE;
    }
}

