/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.codahale.metrics.jetty9;

import cdjd.com.codahale.metrics.Counter;
import cdjd.com.codahale.metrics.Meter;
import cdjd.com.codahale.metrics.MetricRegistry;
import cdjd.com.codahale.metrics.RatioGauge;
import cdjd.com.codahale.metrics.Timer;
import cdjd.org.eclipse.jetty.http.HttpMethod;
import cdjd.org.eclipse.jetty.server.AsyncContextState;
import cdjd.org.eclipse.jetty.server.HttpChannel;
import cdjd.org.eclipse.jetty.server.HttpChannelState;
import cdjd.org.eclipse.jetty.server.Request;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InstrumentedHttpChannelListener
implements HttpChannel.Listener {
    private static final String START_ATTR = InstrumentedHttpChannelListener.class.getName() + ".start";
    private final MetricRegistry metricRegistry;
    private final Timer requests;
    private final Timer dispatches;
    private final Counter activeRequests;
    private final Counter activeDispatches;
    private final Counter activeSuspended;
    private final Meter asyncDispatches;
    private final Meter asyncTimeouts;
    private final Meter[] responses;
    private final Timer getRequests;
    private final Timer postRequests;
    private final Timer headRequests;
    private final Timer putRequests;
    private final Timer deleteRequests;
    private final Timer optionsRequests;
    private final Timer traceRequests;
    private final Timer connectRequests;
    private final Timer moveRequests;
    private final Timer otherRequests;
    private final AsyncListener listener;

    public InstrumentedHttpChannelListener(MetricRegistry registry) {
        this(registry, null);
    }

    public InstrumentedHttpChannelListener(MetricRegistry registry, String pref) {
        this.metricRegistry = registry;
        String prefix = pref == null ? this.getClass().getName() : pref;
        this.requests = this.metricRegistry.timer(MetricRegistry.name(prefix, "requests"));
        this.dispatches = this.metricRegistry.timer(MetricRegistry.name(prefix, "dispatches"));
        this.activeRequests = this.metricRegistry.counter(MetricRegistry.name(prefix, "active-requests"));
        this.activeDispatches = this.metricRegistry.counter(MetricRegistry.name(prefix, "active-dispatches"));
        this.activeSuspended = this.metricRegistry.counter(MetricRegistry.name(prefix, "active-suspended"));
        this.asyncDispatches = this.metricRegistry.meter(MetricRegistry.name(prefix, "async-dispatches"));
        this.asyncTimeouts = this.metricRegistry.meter(MetricRegistry.name(prefix, "async-timeouts"));
        this.responses = new Meter[]{this.metricRegistry.meter(MetricRegistry.name(prefix, "1xx-responses")), this.metricRegistry.meter(MetricRegistry.name(prefix, "2xx-responses")), this.metricRegistry.meter(MetricRegistry.name(prefix, "3xx-responses")), this.metricRegistry.meter(MetricRegistry.name(prefix, "4xx-responses")), this.metricRegistry.meter(MetricRegistry.name(prefix, "5xx-responses"))};
        this.getRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "get-requests"));
        this.postRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "post-requests"));
        this.headRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "head-requests"));
        this.putRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "put-requests"));
        this.deleteRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "delete-requests"));
        this.optionsRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "options-requests"));
        this.traceRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "trace-requests"));
        this.connectRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "connect-requests"));
        this.moveRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "move-requests"));
        this.otherRequests = this.metricRegistry.timer(MetricRegistry.name(prefix, "other-requests"));
        this.metricRegistry.register(MetricRegistry.name(prefix, "percent-4xx-1m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedHttpChannelListener.this.responses[3].getOneMinuteRate(), InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "percent-4xx-5m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedHttpChannelListener.this.responses[3].getFiveMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "percent-4xx-15m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedHttpChannelListener.this.responses[3].getFifteenMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "percent-5xx-1m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedHttpChannelListener.this.responses[4].getOneMinuteRate(), InstrumentedHttpChannelListener.this.requests.getOneMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "percent-5xx-5m"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedHttpChannelListener.this.responses[4].getFiveMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFiveMinuteRate());
            }
        });
        this.metricRegistry.register(MetricRegistry.name(prefix, "percent-5xx-15m"), new RatioGauge(){

            @Override
            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of(InstrumentedHttpChannelListener.this.responses[4].getFifteenMinuteRate(), InstrumentedHttpChannelListener.this.requests.getFifteenMinuteRate());
            }
        });
        this.listener = new AsyncListener(){
            private long startTime;

            public void onTimeout(AsyncEvent event) throws IOException {
                InstrumentedHttpChannelListener.this.asyncTimeouts.mark();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                this.startTime = System.currentTimeMillis();
                event.getAsyncContext().addListener((AsyncListener)this);
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                AsyncContextState state = (AsyncContextState)event.getAsyncContext();
                HttpServletRequest request = (HttpServletRequest)state.getRequest();
                HttpServletResponse response = (HttpServletResponse)state.getResponse();
                InstrumentedHttpChannelListener.this.updateResponses(request, response, this.startTime, true);
                if (!state.getHttpChannelState().isSuspended()) {
                    InstrumentedHttpChannelListener.this.activeSuspended.dec();
                }
            }
        };
    }

    public void onRequestBegin(Request request) {
    }

    public void onBeforeDispatch(Request request) {
        this.before(request);
    }

    public void onDispatchFailure(Request request, Throwable failure) {
    }

    public void onAfterDispatch(Request request) {
        this.after(request);
    }

    public void onRequestContent(Request request, ByteBuffer content) {
    }

    public void onRequestContentEnd(Request request) {
    }

    public void onRequestTrailers(Request request) {
    }

    public void onRequestEnd(Request request) {
    }

    public void onRequestFailure(Request request, Throwable failure) {
    }

    public void onResponseBegin(Request request) {
    }

    public void onResponseCommit(Request request) {
    }

    public void onResponseContent(Request request, ByteBuffer content) {
    }

    public void onResponseEnd(Request request) {
    }

    public void onResponseFailure(Request request, Throwable failure) {
    }

    public void onComplete(Request request) {
    }

    private void before(Request request) {
        long start;
        this.activeDispatches.inc();
        HttpChannelState state = request.getHttpChannelState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.isAsyncStarted()) {
                this.asyncDispatches.mark();
            }
        }
        request.setAttribute(START_ATTR, (Object)start);
    }

    private void after(Request request) {
        long start = (Long)request.getAttribute(START_ATTR);
        long now = System.currentTimeMillis();
        long dispatched = now - start;
        this.activeDispatches.dec();
        this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
        HttpChannelState state = request.getHttpChannelState();
        if (state.isSuspended()) {
            this.activeSuspended.inc();
        } else if (state.isInitial()) {
            this.updateResponses((HttpServletRequest)request, (HttpServletResponse)request.getResponse(), start, request.isHandled());
        }
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long start, boolean isHandled) {
        int responseStatus = isHandled ? response.getStatus() / 100 : 4;
        if (responseStatus >= 1 && responseStatus <= 5) {
            this.responses[responseStatus - 1].mark();
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }

    private Timer requestTimer(String method) {
        HttpMethod m3 = HttpMethod.fromString((String)method);
        if (m3 == null) {
            return this.otherRequests;
        }
        switch (m3) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }
}

