/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessExit {
    private static final Logger logger = LoggerFactory.getLogger("root");

    private ProcessExit() {
    }

    public static void exit(String message, int code) {
        ProcessExit.exit(null, message, code);
    }

    public static void exitHeap(Throwable t) {
        boolean heapExitCode = true;
        try {
            ProcessExit.exit(t, "There was insufficient heap memory to continue operating.", 1);
        }
        finally {
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Throwable t, String message, int code) {
        try {
            logger.error("Dremio is exiting. {}", (Object)message, (Object)t);
            PrintStream out = "true".equals(System.getProperty("dremio.catastrophic_to_standard_out", "true")) ? System.out : System.err;
            out.println("Dremio is exiting. " + message);
            if (t != null) {
                t.printStackTrace(out);
            }
            out.flush();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            Runtime.getRuntime().halt(code);
        }
    }
}

