/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common;

import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.StandardSystemProperty;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VM {
    private static final Logger LOGGER = LoggerFactory.getLogger(VM.class);
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_MATCHER = Pattern.compile("-XX:MaxDirectMemorySize=(?<amount>\\d+)(?<unit>[kKmMgGtT]?)");
    private static final Pattern DEBUG_ARG_MATCHER = Pattern.compile("-Xdebug|-agentlib:jdwp=.*");
    private static final long MAX_DIRECT_MEMORY = VM.maxDirectMemory();
    public static final String DREMIO_CPU_AVAILABLE_PROPERTY = "dremio.cpu.available";
    private static final String DREMIO_LEGACY_CPU_AVAILABLE_PROPERTY = "dremio.executor.cores";
    private static final boolean IS_DEBUG = VM.isDebugEnabled0();
    private static final boolean IS_ASSERT = VM.isAssertEnabled0();
    private static final boolean IS_MACOS_HOST = VM.isMacOSHost0();
    private static final boolean IS_WINDOWS_HOST = VM.isWindowsHost0();

    private VM() {
    }

    public static boolean isDebugEnabled() {
        return IS_DEBUG;
    }

    public static boolean areAssertsEnabled() {
        return IS_ASSERT;
    }

    public static int availableProcessors() {
        int cpuCount = VM.getIntegerSystemProperty(DREMIO_CPU_AVAILABLE_PROPERTY, DREMIO_LEGACY_CPU_AVAILABLE_PROPERTY, 0);
        return cpuCount != 0 ? cpuCount : Runtime.getRuntime().availableProcessors();
    }

    public static long getMaxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static long getMaxHeapMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static boolean isMacOSHost() {
        return IS_MACOS_HOST;
    }

    public static boolean isWindowsHost() {
        return IS_WINDOWS_HOST;
    }

    private static boolean isDebugEnabled0() {
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return VM.isDebugEnabled(inputArguments);
    }

    private static boolean isAssertEnabled0() {
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return inputArguments.contains("-ea");
    }

    @VisibleForTesting
    static boolean isDebugEnabled(List<String> inputArguments) {
        for (String argument : inputArguments) {
            if (!DEBUG_ARG_MATCHER.matcher(argument).matches()) continue;
            return true;
        }
        return false;
    }

    private static final long maxDirectMemory() {
        try {
            return VM.invokeMaxDirectMemory("sun.misc.VM");
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                return VM.invokeMaxDirectMemory("jdk.internal.misc.VM");
            }
            catch (ReflectiveOperationException reflectiveOperationException2) {
                List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
                long maxDirectMemory = VM.maxDirectMemory(inputArguments);
                if (maxDirectMemory != 0L) {
                    return maxDirectMemory;
                }
                return Runtime.getRuntime().maxMemory();
            }
        }
    }

    @VisibleForTesting
    static long maxDirectMemory(List<String> inputArguments) {
        try {
            for (String argument : inputArguments) {
                Matcher matcher = MAX_DIRECT_MEMORY_SIZE_ARG_MATCHER.matcher(argument);
                if (!matcher.matches()) continue;
                long multiplier = 1L;
                switch (matcher.group("unit")) {
                    case "t": 
                    case "T": {
                        multiplier *= 1024L;
                    }
                    case "g": 
                    case "G": {
                        multiplier *= 1024L;
                    }
                    case "m": 
                    case "M": {
                        multiplier *= 1024L;
                    }
                    case "k": 
                    case "K": {
                        multiplier *= 1024L;
                    }
                }
                return Long.parseLong(matcher.group("amount")) * multiplier;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0L;
    }

    private static final long invokeMaxDirectMemory(String className) throws ReflectiveOperationException {
        Class<?> vmClass = Class.forName(className, true, ClassLoader.getSystemClassLoader());
        Method m3 = vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]);
        return ((Number)m3.invoke(null, new Object[0])).longValue();
    }

    @VisibleForTesting
    static final boolean isMacOSHost0() {
        String osName = VM.getOSName().replaceAll("[^a-z0-9]+", "");
        return osName.startsWith("macos") || osName.startsWith("osx");
    }

    @VisibleForTesting
    static final boolean isWindowsHost0() {
        String osName = VM.getOSName();
        return osName.contains("win");
    }

    private static final String getOSName() {
        return Optional.ofNullable(StandardSystemProperty.OS_NAME.value()).orElse("").toLowerCase(Locale.ROOT);
    }

    private static final int getIntegerSystemProperty(String name, String legacyName, int defaultValue) {
        Integer value = Integer.getInteger(name);
        if (value != null) {
            return value;
        }
        value = Integer.getInteger(legacyName);
        if (value != null) {
            LOGGER.warn("System property {} is deprecated. Please use {} instead.", (Object)legacyName, (Object)name);
            return value;
        }
        return defaultValue;
    }
}

