/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.concurrent;

import cdjd.com.dremio.common.concurrent.NamedThreadFactory;
import cdjd.com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableSchedulerThreadPool
extends ScheduledThreadPoolExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CloseableSchedulerThreadPool.class);
    private final String name;

    public CloseableSchedulerThreadPool(String name, int corePoolSize) {
        super(corePoolSize, new NamedThreadFactory(name));
        this.name = name;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t != null) {
            logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t);
        }
        super.afterExecute(r, t);
    }

    @Override
    public void close() throws Exception {
        CloseableSchedulerThreadPool.close(this, logger);
    }

    public static void close(ExecutorService executor, Logger logger) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    logger.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            logger.warn("Executor interrupted while awaiting termination");
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static AutoCloseable of(final ExecutorService executor, final Logger logger) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(logger);
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                CloseableSchedulerThreadPool.close(executor, logger);
            }
        };
    }
}

