/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.exceptions;

import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.common.exceptions.UserRemoteException;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.google.protobuf.Any;
import cdjd.com.google.protobuf.InvalidProtocolBufferException;
import cdjd.com.google.rpc.Status;
import cdjd.io.grpc.Status;
import cdjd.io.grpc.StatusRuntimeException;
import cdjd.io.grpc.protobuf.StatusProto;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcExceptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(GrpcExceptionUtil.class);

    private static Status.Code toCode(UserBitShared.DremioPBError.ErrorType errorType) {
        switch (errorType) {
            case DATA_READ: 
            case DATA_WRITE: {
                return Status.Code.FAILED_PRECONDITION;
            }
            case PERMISSION: {
                return Status.Code.PERMISSION_DENIED;
            }
            case RESOURCE: 
            case RESOURCE_TIMEOUT: {
                return Status.Code.RESOURCE_EXHAUSTED;
            }
            case UNSUPPORTED_OPERATION: {
                return Status.Code.UNIMPLEMENTED;
            }
            case PARSE: 
            case PLAN: 
            case VALIDATION: {
                return Status.Code.INVALID_ARGUMENT;
            }
            case CONCURRENT_MODIFICATION: {
                return Status.Code.ABORTED;
            }
            case FUNCTION: 
            case IO_EXCEPTION: 
            case CONNECTION: 
            case SCHEMA_CHANGE: 
            case INVALID_DATASET_METADATA: 
            case REFLECTION_ERROR: 
            case SOURCE_BAD_STATE: 
            case JSON_FIELD_CHANGE: 
            case SYSTEM: 
            case OUT_OF_MEMORY: {
                return Status.Code.INTERNAL;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static StatusRuntimeException toStatusRuntimeException(UserBitShared.DremioPBError error) {
        return GrpcExceptionUtil.toStatusRuntimeException(error.getMessage(), GrpcExceptionUtil.toCode(error.getErrorType()), UserRemoteException.create(error));
    }

    public static StatusRuntimeException toStatusRuntimeException(UserException ue) {
        return GrpcExceptionUtil.toStatusRuntimeException(ue.getMessage(), GrpcExceptionUtil.toCode(ue.getErrorType()), ue);
    }

    public static StatusRuntimeException toStatusRuntimeException(String message, Status.Code code, UserException ue) {
        return StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(code.value()).setMessage(message).addDetails(Any.pack(ue.getOrCreatePBError(false), "dremio.com/v1/types")).build());
    }

    public static Optional<UserException> fromStatusRuntimeException(StatusRuntimeException sre) {
        Status statusProto = StatusProto.fromThrowable((Throwable)sre);
        if (statusProto == null) {
            return Optional.empty();
        }
        return GrpcExceptionUtil.fromStatus(statusProto);
    }

    public static Optional<UserException> fromStatus(Status statusProto) {
        for (Any details : statusProto.getDetailsList()) {
            if (!details.is(UserBitShared.DremioPBError.class)) continue;
            try {
                return Optional.of(UserRemoteException.create(details.unpack(UserBitShared.DremioPBError.class)));
            }
            catch (InvalidProtocolBufferException e) {
                logger.warn("Received an invalid UserException, ignoring", e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static void throwIfUserException(StatusRuntimeException e) {
        Optional<UserException> userException = GrpcExceptionUtil.fromStatusRuntimeException(e);
        if (userException.isPresent()) {
            throw userException.get();
        }
    }

    private GrpcExceptionUtil() {
    }
}

