/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.expression;

import cdjd.com.dremio.common.expression.PathSegment;
import cdjd.com.dremio.common.expression.ProvidesUnescapedPath;
import cdjd.com.dremio.exec.proto.UserBitShared;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePath
implements ProvidesUnescapedPath {
    protected final PathSegment.NameSegment rootSegment;

    public static BasePath getSimple(String name) {
        return new BasePath(new PathSegment.NameSegment(name)){};
    }

    public PathSegment getLastSegment() {
        PathSegment s2 = this.rootSegment;
        while (s2.getChild() != null) {
            s2 = s2.getChild();
        }
        return s2;
    }

    public UserBitShared.NamePart getAsNamePart() {
        return BasePath.getNamePart(this.rootSegment);
    }

    public <IN, OUT> OUT accept(SchemaPathVisitor<IN, OUT> visitor, IN in) {
        return this.getRootSegment().accept(visitor, in);
    }

    private static UserBitShared.NamePart getNamePart(PathSegment s2) {
        if (s2 == null) {
            return null;
        }
        UserBitShared.NamePart.Builder b = UserBitShared.NamePart.newBuilder();
        if (s2.getChild() != null) {
            b.setChild(BasePath.getNamePart(s2.getChild()));
        }
        if (s2.isArray()) {
            if (s2.getArraySegment().hasIndex()) {
                throw new IllegalStateException("You cannot convert a indexed schema path to a NamePart.  NameParts can only reference Vectors, not individual records or values.");
            }
            b.setType(UserBitShared.NamePart.Type.ARRAY);
        } else {
            b.setType(UserBitShared.NamePart.Type.NAME);
            b.setName(s2.getNameSegment().getPath());
        }
        return b.build();
    }

    public List<String> getNameSegments() {
        ArrayList<String> segments = new ArrayList<String>();
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).isNamed()) continue;
            segments.add(((PathSegment)seg).getNameSegment().getPath());
        }
        return segments;
    }

    public List<String> getComplexNameSegments() {
        ArrayList<String> segments = new ArrayList<String>();
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (((PathSegment)seg).isNamed()) {
                segments.add(((PathSegment)seg).getNameSegment().getPath());
                continue;
            }
            if (!((PathSegment)seg).isArray()) continue;
            segments.add("list");
            segments.add("element");
        }
        return segments;
    }

    protected static PathSegment getPathSegment(UserBitShared.NamePart n) {
        PathSegment child;
        PathSegment pathSegment = child = n.hasChild() ? BasePath.getPathSegment(n.getChild()) : null;
        if (n.getType() == UserBitShared.NamePart.Type.ARRAY) {
            return new PathSegment.ArraySegment(child);
        }
        return new PathSegment.NameSegment(n.getName(), child);
    }

    public boolean isSimplePath() {
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).isArray() || seg.isLastPath()) continue;
            return false;
        }
        return true;
    }

    protected BasePath(BasePath path) {
        this.rootSegment = path.rootSegment;
    }

    public BasePath(PathSegment.NameSegment rootSegment) {
        this.rootSegment = rootSegment;
    }

    public PathSegment.NameSegment getRootSegment() {
        return this.rootSegment;
    }

    @Override
    public String getAsUnescapedPath() {
        StringBuilder sb = new StringBuilder();
        PathSegment seg = this.getRootSegment();
        if (seg.isArray()) {
            throw new IllegalStateException("Dremio doesn't currently support top level arrays");
        }
        sb.append(seg.getNameSegment().getPath());
        while ((seg = seg.getChild()) != null) {
            if (seg.isNamed()) {
                sb.append('.');
                sb.append(seg.getNameSegment().getPath());
                continue;
            }
            sb.append('[');
            sb.append(seg.getArraySegment().getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    public static interface SchemaPathVisitor<IN, OUT> {
        public OUT visitName(PathSegment.NameSegment var1, IN var2);

        public OUT visitArray(PathSegment.ArraySegment var1, IN var2);
    }
}

