/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.logging;

import cdjd.com.dremio.common.logging.ProtobufStructuredLogger;
import cdjd.com.google.protobuf.Message;
import java.util.function.Function;

public interface StructuredLogger<T> {
    public void info(String var1, T var2);

    public void debug(String var1, T var2);

    public static <V extends Message> StructuredLogger<V> get(Class<V> clazz, String loggerName) {
        return ProtobufStructuredLogger.of(loggerName);
    }

    default public <U> StructuredLogger<U> compose(Function<? super U, ? extends T> mapper) {
        return new ComposedStructuredLogger<U, T>(this, mapper);
    }

    public static final class ComposedStructuredLogger<T, R>
    implements StructuredLogger<T> {
        private final StructuredLogger<R> parentLogger;
        private final Function<? super T, ? extends R> mapper;

        public ComposedStructuredLogger(StructuredLogger<R> parentLogger, Function<? super T, ? extends R> mapper) {
            this.parentLogger = parentLogger;
            this.mapper = mapper;
        }

        @Override
        public void info(String message, T data) {
            this.parentLogger.info(message, this.mapper.apply(data));
        }

        @Override
        public void debug(String message, T data) {
            this.parentLogger.debug(message, this.mapper.apply(data));
        }
    }
}

