/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.map;

import cdjd.com.google.common.collect.ImmutableMap;
import cdjd.com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveMap<VALUE>
implements Map<String, VALUE> {
    private final Map<String, VALUE> underlyingMap;

    public static <VALUE> CaseInsensitiveMap<VALUE> newConcurrentMap() {
        return new CaseInsensitiveMap(Maps.newConcurrentMap());
    }

    public static <VALUE> CaseInsensitiveMap<VALUE> newHashMap() {
        return new CaseInsensitiveMap(Maps.newHashMap());
    }

    public static <VALUE> CaseInsensitiveMap<VALUE> newTreeMap(Comparator<String> comparator) {
        return new CaseInsensitiveMap(Maps.newTreeMap(comparator));
    }

    public static <VALUE> CaseInsensitiveMap<VALUE> newImmutableMap(Map<? extends String, ? extends VALUE> map) {
        ImmutableMap.Builder<String, VALUE> builder = ImmutableMap.builder();
        for (Map.Entry<String, VALUE> entry : map.entrySet()) {
            builder.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return new CaseInsensitiveMap(builder.build());
    }

    private CaseInsensitiveMap(Map<String, VALUE> underlyingMap) {
        this.underlyingMap = underlyingMap;
    }

    @Override
    public int size() {
        return this.underlyingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.underlyingMap.containsKey(((String)key).toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.underlyingMap.containsValue(value);
    }

    @Override
    public VALUE get(Object key) {
        return key instanceof String ? (VALUE)this.underlyingMap.get(((String)key).toLowerCase()) : null;
    }

    @Override
    public VALUE put(String key, VALUE value) {
        return this.underlyingMap.put(key.toLowerCase(), value);
    }

    @Override
    public VALUE remove(Object key) {
        return key instanceof String ? (VALUE)this.underlyingMap.remove(((String)key).toLowerCase()) : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends VALUE> map) {
        for (Map.Entry<String, VALUE> entry : map.entrySet()) {
            this.underlyingMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.underlyingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.underlyingMap.keySet();
    }

    @Override
    public Collection<VALUE> values() {
        return this.underlyingMap.values();
    }

    @Override
    public Set<Map.Entry<String, VALUE>> entrySet() {
        return this.underlyingMap.entrySet();
    }
}

