/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.memory;

import cdjd.com.dremio.common.collections.Tuple;
import cdjd.org.apache.arrow.memory.AllocationOutcomeDetails;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.OutOfMemoryException;
import cdjd.org.apache.arrow.memory.util.CommonUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryDebugInfo {
    static final Logger logger = LoggerFactory.getLogger(MemoryDebugInfo.class);
    private static final int NUM_LEVELS_FROM_ROOT_TO_OPERATOR = 6;
    private static final int MAX_NODES_PER_LEVEL_TO_PRINT = 10;
    private static final int MAX_NODES_PER_LEVEL_TO_STORE = 2;

    private static void print(StringBuilder sb, BufferAllocator current, int currentLevel, int maxLevels, int nodesPerLevel) {
        if (currentLevel > maxLevels) {
            return;
        }
        Collection<BufferAllocator> childAllocators = current.getChildAllocators();
        CommonUtil.indent(sb, currentLevel).append("Allocator(").append(current.getName()).append(") ").append(current.getInitReservation()).append('/').append(current.getAllocatedMemory()).append('/').append(current.getPeakMemoryAllocation()).append('/').append(current.getLimit()).append(" (res/actual/peak/limit)").append(" numChildAllocators:").append(childAllocators.size()).append('\n');
        for (BufferAllocator child : MemoryDebugInfo.pruneAllocatorList(childAllocators, nodesPerLevel)) {
            MemoryDebugInfo.print(sb, child, currentLevel + 1, maxLevels, nodesPerLevel);
        }
    }

    private static Collection<BufferAllocator> pruneAllocatorList(Collection<BufferAllocator> allocators, int nodesPerLevel) {
        if (allocators.size() <= nodesPerLevel) {
            return allocators;
        }
        return allocators.stream().map(allocator -> Tuple.of(allocator.getAllocatedMemory(), allocator)).sorted(Comparator.comparingLong(tuple -> -((Long)tuple.first).longValue())).limit(nodesPerLevel).map(tuple -> (BufferAllocator)tuple.second).collect(Collectors.toList());
    }

    private static String getSummary(BufferAllocator start, int numLevels, int nodesPerLevel) {
        StringBuilder sb = new StringBuilder();
        MemoryDebugInfo.print(sb, start, 0, numLevels, nodesPerLevel);
        return sb.toString();
    }

    private static String getSummaryFromRoot(BufferAllocator allocator, int nodesPerLevel) {
        BufferAllocator root = allocator;
        while (root.getParentAllocator() != null) {
            root = root.getParentAllocator();
        }
        return MemoryDebugInfo.getSummary(root, 6, nodesPerLevel);
    }

    public static String getSummaryFromRoot(BufferAllocator allocator) {
        return MemoryDebugInfo.getSummaryFromRoot(allocator, 2);
    }

    public static String getDetailsOnAllocationFailure(OutOfMemoryException exception, BufferAllocator allocator) {
        String printSummary;
        String summary;
        BufferAllocator failedAtAllocator = null;
        StringBuilder sb = new StringBuilder();
        Optional<AllocationOutcomeDetails> outcomeDetails = exception.getOutcomeDetails();
        if (outcomeDetails.isPresent()) {
            sb.append(outcomeDetails.get().toString());
            failedAtAllocator = outcomeDetails.get().getFailedAllocator();
        }
        if (failedAtAllocator == null) {
            summary = MemoryDebugInfo.getSummaryFromRoot(allocator, 2);
            printSummary = MemoryDebugInfo.getSummaryFromRoot(allocator, 10);
        } else if (failedAtAllocator.getParentAllocator() == null) {
            summary = MemoryDebugInfo.getSummaryFromRoot(failedAtAllocator, 2);
            printSummary = MemoryDebugInfo.getSummaryFromRoot(failedAtAllocator, 10);
        } else {
            summary = MemoryDebugInfo.getSummary(failedAtAllocator, 3, 2);
            printSummary = MemoryDebugInfo.getSummary(failedAtAllocator, 3, 10);
        }
        sb.append("\nAllocator dominators:\n");
        sb.append(summary);
        logger.info("\nAllocation failure: \nDetailed Allocator dominators:\n " + printSummary);
        return sb.toString();
    }
}

