/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.scanner;

import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.common.scanner.BuildTimeScan;
import cdjd.com.dremio.common.scanner.ClassPathScanner;
import cdjd.com.dremio.common.scanner.persistence.ScanResult;
import java.net.URL;
import java.util.Collection;
import java.util.List;

public class RunTimeScan {
    private static final ScanResult PRESCANNED = BuildTimeScan.load();
    private static final Collection<URL> NON_PRESCANNED_MARKED_PATHS = RunTimeScan.getNonPrescannedMarkedPaths();

    static Collection<URL> getNonPrescannedMarkedPaths() {
        Collection<URL> markedPaths = ClassPathScanner.getMarkedPaths();
        markedPaths.removeAll(BuildTimeScan.getPrescannedPaths());
        return markedPaths;
    }

    public static ScanResult fromPrescan(SabotConfig config) {
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        List<String> scannedBaseClasses = ClassPathScanner.getScannedBaseClasses(config);
        List<String> scannedAnnotations = ClassPathScanner.getScannedAnnotations(config);
        if (ClassPathScanner.isScanBuildTimeCacheEnabled(config)) {
            ScanResult runtimeScan = ClassPathScanner.scan(NON_PRESCANNED_MARKED_PATHS, packagePrefixes, scannedBaseClasses, scannedAnnotations, PRESCANNED);
            return runtimeScan.merge(PRESCANNED);
        }
        return ClassPathScanner.scan(ClassPathScanner.getMarkedPaths(), packagePrefixes, scannedBaseClasses, scannedAnnotations, ClassPathScanner.emptyResult());
    }
}

