/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.types;

import cdjd.com.dremio.common.expression.CompleteType;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import java.util.Optional;

public class TypeCoercionRules {
    public static Optional<CompleteType> getResultantType(CompleteType fileType, CompleteType tableType) {
        if (fileType.equals(CompleteType.NULL)) {
            return Optional.of(tableType);
        }
        if (fileType.equals(CompleteType.INT)) {
            return TypeCoercionRules.getResultantTypeForIntFileType(tableType);
        }
        if (fileType.equals(CompleteType.BIGINT)) {
            return TypeCoercionRules.getResultantTypeForBigIntFileType(tableType);
        }
        if (fileType.equals(CompleteType.FLOAT)) {
            return TypeCoercionRules.getResultantTypeForFloatFileType(tableType);
        }
        if (fileType.equals(CompleteType.DOUBLE)) {
            return TypeCoercionRules.getResultantTypeForDoubleFileType(tableType);
        }
        if (fileType.equals(CompleteType.BIT)) {
            return TypeCoercionRules.getResultantTypeForBooleanFileType(tableType);
        }
        if (fileType.isValidDecimal()) {
            return TypeCoercionRules.getResultantTypeForDecimalFileType(tableType);
        }
        if (fileType.isTemporal()) {
            return TypeCoercionRules.getResultantTypeForTemporalFileType(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForIntFileType(CompleteType tableType) {
        if (tableType.getType().getTypeID().equals((Object)ArrowType.ArrowTypeID.FloatingPoint)) {
            return Optional.of(CompleteType.DOUBLE);
        }
        if (tableType.isValidDecimal() || tableType.equals(CompleteType.BIGINT) || tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForBigIntFileType(CompleteType tableType) {
        if (tableType.getType().getTypeID().equals((Object)ArrowType.ArrowTypeID.FloatingPoint)) {
            return Optional.of(CompleteType.DOUBLE);
        }
        if (tableType.isValidDecimal() || tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForFloatFileType(CompleteType tableType) {
        if (tableType.isValidDecimal() || tableType.isText() || tableType.equals(CompleteType.DOUBLE)) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForDoubleFileType(CompleteType tableType) {
        if (tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForBooleanFileType(CompleteType tableType) {
        if (tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForDecimalFileType(CompleteType tableType) {
        if (tableType.isValidDecimal() || tableType.isText() || tableType.equals(CompleteType.DOUBLE)) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    private static Optional<CompleteType> getResultantTypeForTemporalFileType(CompleteType tableType) {
        if (tableType.isText()) {
            return Optional.of(tableType);
        }
        return Optional.empty();
    }
}

