/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.org.joda.time.DateTime;
import cdjd.org.joda.time.DateTimeZone;
import cdjd.org.joda.time.LocalDateTimes;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class DateTimes {
    public static final DateTimeFormatter CALCITE_LOCAL_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final DateTimeFormatter CALCITE_LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter CALCITE_LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(CALCITE_LOCAL_DATE_FORMATTER).appendLiteral(' ').append(CALCITE_LOCAL_TIME_FORMATTER).toFormatter();

    public static long toMillis(cdjd.org.joda.time.LocalDateTime localDateTime) {
        return LocalDateTimes.getLocalMillis(localDateTime);
    }

    public static long toMillis(DateTime dateTime) {
        return dateTime.toDateTime(DateTimeZone.UTC).getMillis();
    }

    public static int toMillisOfDay(DateTime dateTime) {
        return dateTime.toDateTime(DateTimeZone.UTC).millisOfDay().get();
    }

    public static long toMillisFromJdbcDate(String jdbcEscapeString) {
        return DateTimes.toMillis(new cdjd.org.joda.time.LocalDateTime(Date.valueOf(jdbcEscapeString).getTime()));
    }

    public static long toMillisFromJdbcTimestamp(String jdbcEscapeString) {
        return DateTimes.toMillis(new cdjd.org.joda.time.LocalDateTime(Timestamp.valueOf(jdbcEscapeString).getTime()));
    }

    public static long toJavaTimeMillisFromJdbcDate(String jdbcEscapeString) {
        LocalDate localDate = LocalDate.parse(jdbcEscapeString, CALCITE_LOCAL_DATE_FORMATTER);
        return localDate.atTime(LocalTime.MIDNIGHT).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static long toJavaTimeMillisFromJdbcTimestamp(String jdbcEscapeString) {
        LocalDateTime localDateTime = LocalDateTime.parse(jdbcEscapeString, CALCITE_LOCAL_DATETIME_FORMATTER);
        return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public static String toJdbcDateFromMillisInUtc(long millis) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
        return localDateTime.toLocalDate().format(CALCITE_LOCAL_DATE_FORMATTER);
    }

    public static String toJdbcTimestampFromMillisInUtc(long millis) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
        return localDateTime.format(CALCITE_LOCAL_DATETIME_FORMATTER);
    }

    public static DateTime toDateTime(cdjd.org.joda.time.LocalDateTime localDateTime) {
        return localDateTime.toDateTime(DateTimeZone.UTC);
    }
}

