/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.com.dremio.common.util.JodaDateUtility;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.org.apache.commons.lang3.StringEscapeUtils;
import cdjd.org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DremioStringUtils {
    private static final Logger logger = LoggerFactory.getLogger(DremioStringUtils.class);

    public static String readable(long bytes) {
        int unit = 1024;
        long absBytes = Math.abs(bytes);
        if (absBytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(absBytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%s%.1f %ciB", bytes == absBytes ? "" : "-", (double)absBytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static String firstLine(String input) {
        return input.split("\n|\r|\r\n", 2)[0];
    }

    public static final String unescapeJava(String input) {
        return StringEscapeUtils.unescapeJava(input);
    }

    public static final String escapeJava(String input) {
        return StringEscapeUtils.escapeJava(input);
    }

    public static final String escapeNewLines(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean sawNewline = false;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (curChar == '\r' || curChar == '\n') {
                if (sawNewline) continue;
                sawNewline = true;
                result.append("\\n");
                continue;
            }
            sawNewline = false;
            result.append(curChar);
        }
        return result.toString();
    }

    public static String convertStringToPascalCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    public static String escapeSql(String str) {
        return str == null ? null : str.replace("'", "''");
    }

    public static String toBinaryString(ByteBuf buf, int strStart, int strEnd) {
        StringBuilder result = new StringBuilder();
        for (int i = strStart; i < strEnd; ++i) {
            DremioStringUtils.appendByte(result, buf.getByte(i));
        }
        return result.toString();
    }

    public static String toBinaryString(byte[] buf) {
        return DremioStringUtils.toBinaryString(buf, 0, buf.length);
    }

    public static String toBinaryString(byte[] buf, int strStart, int strEnd) {
        StringBuilder result = new StringBuilder();
        for (int i = strStart; i < strEnd; ++i) {
            DremioStringUtils.appendByte(result, buf[i]);
        }
        return result.toString();
    }

    private static void appendByte(StringBuilder result, byte b) {
        int ch = b & 0xFF;
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
            result.append((char)ch);
        } else {
            result.append(String.format("\\x%02X", ch));
        }
    }

    private static void appendByteNoFormat(StringBuilder result, byte b) {
        int ch = b & 0xFF;
        result.append(String.format("%02X", ch));
    }

    public static String toBinaryStringNoFormat(ByteBuf buf, int strStart, int strEnd) {
        StringBuilder result = new StringBuilder();
        for (int i = strStart; i < strEnd; ++i) {
            DremioStringUtils.appendByteNoFormat(result, buf.getByte(i));
        }
        return result.toString();
    }

    public static int parseBinaryString(ByteBuf str, int strStart, int strEnd, ByteBuf out) {
        int dstEnd = 0;
        for (int i = strStart; i < strEnd; ++i) {
            byte b = str.getByte(i);
            if (b == 92 && strEnd > i + 3 && (str.getByte(i + 1) == 120 || str.getByte(i + 1) == 88)) {
                byte hd1 = str.getByte(i + 2);
                byte hd2 = str.getByte(i + 3);
                if (DremioStringUtils.isHexDigit(hd1) && DremioStringUtils.isHexDigit(hd2)) {
                    b = (byte)((DremioStringUtils.toBinaryFromHex(hd1) << 4) + DremioStringUtils.toBinaryFromHex(hd2));
                    i += 3;
                }
            }
            out.setByte(dstEnd++, b);
        }
        return dstEnd;
    }

    public static String formatIntervalYear(Period p) {
        long months = (long)p.getYears() * 12L + (long)p.getMonths();
        boolean neg = false;
        if (months < 0L) {
            months = -months;
            neg = true;
        }
        int years = (int)(months / 12L);
        return String.format("%c%03d-%02d", Character.valueOf(neg ? (char)'-' : '+'), years, months %= 12L);
    }

    public static String formatIntervalDay(Period p) {
        long millis = (long)p.getDays() * 86400000L + (long)JodaDateUtility.millisFromPeriod(p);
        boolean neg = false;
        if (millis < 0L) {
            millis = -millis;
            neg = true;
        }
        int days = (int)(millis / 86400000L);
        int hours = (int)((millis %= 86400000L) / 3600000L);
        int minutes = (int)((millis %= 3600000L) / 60000L);
        int seconds = (int)((millis %= 60000L) / 1000L);
        return String.format("%c%03d %02d:%02d:%02d.%03d", Character.valueOf(neg ? (char)'-' : '+'), days, hours, minutes, seconds, millis %= 1000L);
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        if (ch >= 97 && ch <= 102) {
            return (byte)(10 + (byte)(ch - 97));
        }
        return (byte)(ch - 48);
    }

    public static boolean isHexDigit(byte c) {
        return c >= 97 && c <= 102 || c >= 65 && c <= 70 || c >= 48 && c <= 57;
    }
}

