/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.common.concurrent.CloseableSchedulerThreadPool;
import cdjd.com.dremio.common.util.MayExpire;
import cdjd.com.google.common.cache.CacheBuilder;
import cdjd.com.google.common.cache.CacheLoader;
import cdjd.com.google.common.cache.ForwardingLoadingCache;
import cdjd.com.google.common.cache.LoadingCache;
import cdjd.com.google.common.cache.RemovalListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingCacheWithExpiry<K, V extends MayExpire>
extends ForwardingLoadingCache<K, V>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LoadingCacheWithExpiry.class);
    private final LoadingCache<K, V> inner;
    private final CloseableSchedulerThreadPool scheduler;

    public LoadingCacheWithExpiry(String name, CacheLoader<K, V> loader, RemovalListener removalListener, long refreshDelayMs) {
        this.inner = removalListener != null ? CacheBuilder.newBuilder().removalListener(removalListener).build(loader) : CacheBuilder.newBuilder().build(loader);
        this.scheduler = new CloseableSchedulerThreadPool("cache-cleaner-" + name, 1);
        this.initEvictionAction(refreshDelayMs);
    }

    private void initEvictionAction(long refreshDelayMs) {
        this.scheduler.scheduleWithFixedDelay(this.getEvictionAction(), refreshDelayMs, refreshDelayMs, TimeUnit.MILLISECONDS);
    }

    public void checkAndEvict() {
        this.getEvictionAction().run();
    }

    private Runnable getEvictionAction() {
        return () -> {
            for (Map.Entry entry : this.inner.asMap().entrySet()) {
                try {
                    if (!((MayExpire)entry.getValue()).isExpired()) continue;
                    this.inner.invalidate(entry.getKey());
                }
                catch (Throwable e) {
                    logger.warn("Failed to evict entry");
                }
            }
        };
    }

    @Override
    protected LoadingCache<K, V> delegate() {
        return this.inner;
    }

    @Override
    public void close() throws Exception {
        this.inner.invalidateAll();
        AutoCloseables.close(this.scheduler);
    }
}

