/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util;

import java.text.DecimalFormat;

public class PrettyPrintUtils {
    private static final DecimalFormat dec = new DecimalFormat("0.00");
    private static final DecimalFormat intformat = new DecimalFormat("#,###");

    public static String bytePrint(long size, boolean displayTinyValues) {
        double t = (double)size / Math.pow(1024.0, 4.0);
        if (t > 1.0) {
            return dec.format(t).concat("TB");
        }
        double g2 = (double)size / Math.pow(1024.0, 3.0);
        if (g2 > 1.0) {
            return dec.format(g2).concat("GB");
        }
        double m3 = (double)size / Math.pow(1024.0, 2.0);
        if (m3 > 1.0) {
            return intformat.format(m3).concat("MB");
        }
        double k = size / 1024L;
        if (k >= 1.0) {
            return intformat.format(k).concat("KB");
        }
        if (displayTinyValues) {
            return "<1 KB";
        }
        return "-";
    }
}

