/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.util.concurrent;

import cdjd.com.dremio.common.util.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextClassLoaderSwapper
implements Closeable {
    private final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private static final Logger logger = LoggerFactory.getLogger(ContextClassLoaderSwapper.class);

    private ContextClassLoaderSwapper(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @Override
    public void close() {
        logger.debug("Loading original class loader {}", (Object)this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    public static Closeable swapClassLoader(Class<?> classObj) {
        logger.debug("Current class loader swapped with {} class loader", (Object)classObj.getClassLoader());
        return new ContextClassLoaderSwapper(classObj.getClassLoader());
    }
}

