/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils;

import java.util.UUID;

public final class UUIDAdapter {
    private UUIDAdapter() {
    }

    public static byte[] getBytesFromUUID(UUID uuid) {
        int i;
        byte[] result = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        for (i = 15; i >= 8; --i) {
            result[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        for (i = 7; i >= 0; --i) {
            result[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        return result;
    }

    public static UUID getUUIDFromBytes(byte[] bytes) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (bytes.length == 16) : "bytes must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

