/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils.protos;

import cdjd.com.dremio.common.utils.protos.AttemptId;
import cdjd.com.dremio.common.utils.protos.QueryIdHelper;
import cdjd.com.dremio.exec.proto.UserBitShared;
import java.util.UUID;

public final class AttemptIdUtils {
    private AttemptIdUtils() {
    }

    public static String toString(AttemptId attemptId) {
        return QueryIdHelper.getQueryId(attemptId.toQueryId());
    }

    public static AttemptId fromString(String attemptIdStr) {
        UUID uuid = UUID.fromString(attemptIdStr);
        long part1 = uuid.getMostSignificantBits();
        long part2 = uuid.getLeastSignificantBits();
        UserBitShared.ExternalId externalId = UserBitShared.ExternalId.newBuilder().setPart1(part1).setPart2(part2 & 0xFFFFFFFFFFFFFF00L).build();
        int attempt = (int)part2 & 0xFF;
        return new AttemptId(externalId, attempt);
    }
}

