/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.common.utils.protos;

import cdjd.com.dremio.common.utils.protos.QueryIdHelper;
import cdjd.com.dremio.common.utils.protos.QueryWritableBatch;
import cdjd.com.dremio.exec.proto.UserBitShared;
import java.util.concurrent.ThreadLocalRandom;

public final class ExternalIdHelper {
    public static final long MASK = -256L;

    public static QueryWritableBatch replaceQueryId(QueryWritableBatch batch, UserBitShared.ExternalId externalId) {
        UserBitShared.QueryData header = UserBitShared.QueryData.newBuilder(batch.getHeader()).setQueryId(ExternalIdHelper.toQueryId(externalId)).build();
        return new QueryWritableBatch(header, batch.getBuffers());
    }

    public static UserBitShared.QueryResult replaceQueryId(UserBitShared.QueryResult queryResult, UserBitShared.ExternalId externalId) {
        return UserBitShared.QueryResult.newBuilder(queryResult).setQueryId(ExternalIdHelper.toQueryId(externalId)).build();
    }

    public static UserBitShared.ExternalId generateExternalId() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        long time = (int)(System.currentTimeMillis() / 1000L);
        long p1 = (Integer.MAX_VALUE - time << 32) + (long)r.nextInt();
        byte[] bytes = new byte[7];
        r.nextBytes(bytes);
        long p2 = 0L;
        for (int i = 0; i < 7; ++i) {
            p2 += ((long)bytes[i] & 0xFFL) << 8 * i;
        }
        return UserBitShared.ExternalId.newBuilder().setPart1(p1).setPart2(p2 <<= 8).build();
    }

    public static UserBitShared.QueryId toQueryId(UserBitShared.ExternalId externalId) {
        return UserBitShared.QueryId.newBuilder().setPart1(externalId.getPart1()).setPart2(externalId.getPart2()).build();
    }

    @Deprecated
    public static UserBitShared.ExternalId toExternal(UserBitShared.QueryId queryId) {
        return UserBitShared.ExternalId.newBuilder().setPart1(queryId.getPart1()).setPart2(queryId.getPart2() & 0xFFFFFFFFFFFFFF00L).build();
    }

    public static boolean isValid(UserBitShared.ExternalId externalId) {
        return (externalId.getPart2() & 0xFFL) == 0L;
    }

    public static String toString(UserBitShared.ExternalId externalId) {
        return QueryIdHelper.getQueryId(ExternalIdHelper.toQueryId(externalId));
    }
}

