/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.exception;

import cdjd.com.dremio.common.expression.CompleteType;
import java.util.ArrayList;
import java.util.List;

public class NoSupportedUpPromotionOrCoercionException
extends RuntimeException {
    private final CompleteType fileType;
    private final CompleteType tableType;
    private final List<String> columns;
    private List<String> datasetPath;
    private String filePath;

    public NoSupportedUpPromotionOrCoercionException(CompleteType fileType, CompleteType tableType) {
        this.fileType = fileType;
        this.tableType = tableType;
        this.columns = new ArrayList<String>();
    }

    @Override
    public String getMessage() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to coerce from the file's data type \"");
        sb.append(this.fileType);
        sb.append("\" to the column's data type \"");
        sb.append(this.tableType);
        sb.append("\"");
        if (this.datasetPath != null && this.datasetPath.size() > 0) {
            sb.append(" in table \"");
            for (i = 0; i < this.datasetPath.size() - 1; ++i) {
                sb.append(this.datasetPath.get(i));
                sb.append(".");
            }
            sb.append(this.datasetPath.get(this.datasetPath.size() - 1));
            sb.append("\"");
        }
        if (this.columns != null && this.columns.size() > 0) {
            sb.append(", column \"");
            for (i = this.columns.size() - 1; i > 0; --i) {
                sb.append(this.columns.get(i));
                sb.append(".");
            }
            sb.append(this.columns.get(0));
            sb.append("\"");
        }
        if (this.filePath != null) {
            sb.append(" and file \"");
            sb.append(this.filePath);
            sb.append("\"");
        }
        return sb.toString();
    }

    public void addColumnName(String name) {
        this.columns.add(name);
    }

    public void addFilePath(String path) {
        this.filePath = path;
    }

    public void addDatasetPath(List<String> datasetPath) {
        this.datasetPath = datasetPath;
    }
}

