/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.rpc.InboundRpcMessage;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.google.protobuf.Internal;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.com.google.protobuf.Parser;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandshakeHandler<T extends MessageLite>
extends MessageToMessageDecoder<InboundRpcMessage> {
    static final Logger logger = LoggerFactory.getLogger(AbstractHandshakeHandler.class);
    protected final Internal.EnumLite handshakeType;
    protected final Parser<T> parser;
    protected volatile int coordinationId;

    AbstractHandshakeHandler(Internal.EnumLite handshakeType, Parser<T> parser) {
        this.handshakeType = handshakeType;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, InboundRpcMessage inbound, List<Object> outputs) throws Exception {
        try {
            this.coordinationId = inbound.coordinationId;
            ctx.channel().pipeline().remove(this);
            if (inbound.rpcType != this.handshakeType.getNumber()) {
                throw new RpcException(String.format("Handshake failure.  Expected %s[%d] but received number [%d]", this.handshakeType, this.handshakeType.getNumber(), inbound.rpcType));
            }
            MessageLite msg = (MessageLite)this.parser.parseFrom(inbound.getProtobufBodyAsIS());
            this.consumeHandshake(ctx, msg);
        }
        finally {
            if (inbound.dBody != null) {
                inbound.dBody.release();
            }
        }
    }

    protected abstract void consumeHandshake(ChannelHandlerContext var1, T var2) throws Exception;
}

