/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.common.SerializedExecutor;
import cdjd.com.dremio.exec.rpc.AbstractClient;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.RpcCommand;
import cdjd.com.dremio.exec.rpc.RpcConnectionHandler;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.telemetry.api.metrics.Counter;
import cdjd.com.dremio.telemetry.api.metrics.Metrics;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.io.netty.channel.ChannelFuture;
import cdjd.io.netty.channel.ChannelFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconnectingConnection<CONNECTION_TYPE extends RemoteConnection, OUTBOUND_HANDSHAKE extends MessageLite>
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Counter CONNECTION_BREAK_15M = Metrics.newCounter(Metrics.join("rpc", "failure_15m"), Metrics.ResetType.PERIODIC_15M);
    private static final Counter CONNECTION_BREAK_1D = Metrics.newCounter(Metrics.join("rpc", "failure_1d"), Metrics.ResetType.PERIODIC_1D);
    private static final long LOST_CONNECTION_REATTEMPT = TimeUnit.MINUTES.toMillis(2L);
    private static final long CONNECTION_SUCCESS_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private static final long TIME_BETWEEN_ATTEMPT = TimeUnit.SECONDS.toMillis(5L);
    private static final int LAZY_ERROR_NOTIFY_RETRIES = Integer.parseInt(System.getProperty("dremio.exec.rpcNotifyRetries", "4"));
    private final AtomicReference<CONNECTION_TYPE> connectionHolder = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String host;
    private final int port;
    private final OUTBOUND_HANDSHAKE handshake;
    private final String name;
    private final Exec connector;
    private final long lostConnectionReattemptMS;
    private final long connectionSuccessTimeoutMS;
    private final long timeBetweenAttemptMS;
    private volatile ConnectionFailure lastConnectionFailure;

    public ReconnectingConnection(String name, OUTBOUND_HANDSHAKE handshake, String host, int port) {
        this(name, handshake, host, port, LOST_CONNECTION_REATTEMPT, CONNECTION_SUCCESS_TIMEOUT, TIME_BETWEEN_ATTEMPT);
    }

    public ReconnectingConnection(String name, OUTBOUND_HANDSHAKE handshake, String host, int port, long lostConnectionReattemptMS, long connectionSuccessTimeoutMS, long timeBetweenAttemptMS) {
        Preconditions.checkNotNull(host);
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(port > 0);
        this.host = host;
        this.port = port;
        this.name = name;
        this.handshake = handshake;
        this.connector = new Exec();
        this.lostConnectionReattemptMS = lostConnectionReattemptMS;
        this.connectionSuccessTimeoutMS = connectionSuccessTimeoutMS;
        this.timeBetweenAttemptMS = timeBetweenAttemptMS;
    }

    protected abstract AbstractClient<?, CONNECTION_TYPE, OUTBOUND_HANDSHAKE> getNewClient() throws RpcException;

    public <R extends MessageLite, C extends RpcCommand<R, CONNECTION_TYPE>> void runCommand(C cmd) {
        if (this.closed.get()) {
            cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new IOException("Connection has been closed: " + this.toString()));
        }
        ConnectionRunner r = new ConnectionRunner();
        this.connector.execute(r);
        r.executeCommand(cmd);
    }

    public CloseHandlerCreator getCloseHandlerCreator() {
        return new CloseHandlerCreator();
    }

    public void addExternalConnection(CONNECTION_TYPE connection) {
        this.connectionHolder.compareAndSet(null, connection);
    }

    @Override
    public void close() {
        RemoteConnection c;
        if (this.closed.getAndSet(true)) {
            this.logger.info("Attempting to close connection again");
        }
        if ((c = (RemoteConnection)this.connectionHolder.getAndSet(null)) != null) {
            try {
                c.getChannel().close().sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void scheduleNotifyHandler(CONNECTION_TYPE conn, int retries) {
        Runnable notifyHandler = () -> {
            boolean notified;
            if (retries > 1) {
                this.logger.info("Pending completion notification for connection `{}`, possibly due to backpressure. Retry attempt #{}", (Object)conn.getName(), (Object)retries);
            }
            if (!(notified = conn.doLazyNotifyOnClose(retries >= LAZY_ERROR_NOTIFY_RETRIES))) {
                this.scheduleNotifyHandler(conn, retries + 1);
            }
        };
        ((RemoteConnection)conn).getChannel().eventLoop().schedule(notifyHandler, retries == 0 ? 100L : (long)retries * 200L, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return String.format("[%s] %s:%d", this.name, this.host, this.port);
    }

    private class ConnectionFailure {
        private final long validUntil;
        private final RpcConnectionHandler.FailureType type;
        private final Throwable throwable;

        public ConnectionFailure(RpcConnectionHandler.FailureType type, Throwable throwable) {
            this.validUntil = System.currentTimeMillis() + ReconnectingConnection.this.lostConnectionReattemptMS;
            this.type = type;
            this.throwable = throwable;
            CONNECTION_BREAK_15M.increment(new String[0]);
            CONNECTION_BREAK_1D.increment(new String[0]);
        }

        private boolean isStillValid() {
            return System.currentTimeMillis() < this.validUntil;
        }
    }

    private static class ConnectionResult {
        private final boolean hadToConnect;
        private final CONNECTION_TYPE connection;
        private final ConnectionFailure failure;
        final /* synthetic */ ReconnectingConnection this$0;

        public ConnectionResult(boolean hadToConnect, CONNECTION_TYPE connection) {
            this.this$0 = var1_1;
            this.hadToConnect = hadToConnect;
            this.connection = connection;
            this.failure = null;
        }

        public ConnectionResult(ReconnectingConnection reconnectingConnection, ConnectionFailure failure) {
            this.this$0 = reconnectingConnection;
            this.hadToConnect = false;
            this.connection = null;
            this.failure = failure;
        }

        public ConnectionResult(ReconnectingConnection reconnectingConnection, Throwable t) {
            this(reconnectingConnection, reconnectingConnection.new ConnectionFailure(RpcConnectionHandler.FailureType.CONNECTION, t));
        }

        public boolean ok() {
            return this.failure == null;
        }

        public boolean hadToConnect() {
            return this.hadToConnect;
        }

        public void discard() {
            if (this.connection != null) {
                try {
                    ((RemoteConnection)this.connection).getChannel().close().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class ConnectionHandle
    implements RpcConnectionHandler<CONNECTION_TYPE> {
        private CompletableFuture<ConnectionResult> conn = new CompletableFuture();
        private boolean tookTooLong;

        private ConnectionHandle() {
        }

        @Override
        public synchronized void connectionSucceeded(CONNECTION_TYPE connection) {
            if (!this.tookTooLong) {
                this.conn.complete(new ConnectionResult(ReconnectingConnection.this, true, connection));
                return;
            }
            try {
                ((RemoteConnection)connection).getChannel().close().sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            if (!this.tookTooLong) {
                this.conn.complete(new ConnectionResult(ReconnectingConnection.this, new ConnectionFailure(type, t)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionResult waitForFinished(long untilTime) {
            try {
                ConnectionResult connectionResult = this.conn.get(Math.max(1L, untilTime - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
                return connectionResult;
            }
            catch (InterruptedException | TimeoutException e) {
                ConnectionResult connectionResult = new ConnectionResult(ReconnectingConnection.this, new ConnectionFailure(RpcConnectionHandler.FailureType.CONNECTION, e));
                return connectionResult;
            }
            catch (ExecutionException e) {
                ConnectionResult connectionResult = new ConnectionResult(ReconnectingConnection.this, new ConnectionFailure(RpcConnectionHandler.FailureType.CONNECTION, e.getCause()));
                return connectionResult;
            }
            finally {
                this.tookTooLong = true;
            }
        }
    }

    private class ConnectionRunner
    implements Runnable {
        private final CompletableFuture<ConnectionResult> futureConnection = new CompletableFuture();

        private ConnectionRunner() {
        }

        @Override
        public void run() {
            RemoteConnection conn;
            do {
                if ((conn = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get()) == null || !conn.isActive()) continue;
                this.futureConnection.complete(new ConnectionResult(ReconnectingConnection.this, false, conn));
                return;
            } while (!ReconnectingConnection.this.connectionHolder.compareAndSet(conn, null));
            ConnectionFailure failure = ReconnectingConnection.this.lastConnectionFailure;
            if (failure != null && failure.isStillValid()) {
                this.futureConnection.complete(new ConnectionResult(ReconnectingConnection.this, failure));
                return;
            }
            ReconnectingConnection.this.logger.info("[{}]: No connection active, opening new connection to {}:{}.", ReconnectingConnection.this.name, ReconnectingConnection.this.host, ReconnectingConnection.this.port);
            long runUntil = System.currentTimeMillis() + ReconnectingConnection.this.connectionSuccessTimeoutMS;
            ConnectionResult lastResult = null;
            while (System.currentTimeMillis() < runUntil) {
                try {
                    ConnectionResult result = this.attempt(runUntil);
                    if (result.ok()) {
                        this.futureConnection.complete(result);
                        return;
                    }
                    lastResult = result;
                    try {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime + ReconnectingConnection.this.timeBetweenAttemptMS < runUntil) {
                            Thread.sleep(ReconnectingConnection.this.timeBetweenAttemptMS);
                            continue;
                        }
                        Thread.sleep(currentTime < runUntil ? runUntil - currentTime : 0L);
                    }
                    catch (InterruptedException currentTime) {}
                }
                catch (RpcException e) {
                    ConnectionResult failureResult = new ConnectionResult(ReconnectingConnection.this, e);
                    ReconnectingConnection.this.lastConnectionFailure = failureResult.failure;
                    this.futureConnection.complete(failureResult);
                    return;
                }
            }
            if (lastResult == null) {
                lastResult = new ConnectionResult(ReconnectingConnection.this, new TimeoutException("Unable to connect within requested time for " + this.toString()));
            }
            ReconnectingConnection.this.lastConnectionFailure = lastResult.failure;
            this.futureConnection.complete(lastResult);
        }

        private ConnectionResult attempt(long runUntil) throws RpcException {
            ConnectionHandle future = new ConnectionHandle();
            AbstractClient client = ReconnectingConnection.this.getNewClient();
            client.connectAsClient(future, ReconnectingConnection.this.handshake, ReconnectingConnection.this.host, ReconnectingConnection.this.port);
            ConnectionResult result = future.waitForFinished(runUntil);
            if (!result.ok()) {
                return result;
            }
            boolean wasSet = ReconnectingConnection.this.connectionHolder.compareAndSet(null, result.connection);
            if (wasSet) {
                return result;
            }
            result.discard();
            RemoteConnection outsideSet = (RemoteConnection)ReconnectingConnection.this.connectionHolder.get();
            if (outsideSet == null) {
                return new ConnectionResult(ReconnectingConnection.this, new IllegalStateException("Connection was attempted but then identified as missing " + this.toString()));
            }
            return new ConnectionResult(ReconnectingConnection.this, false, outsideSet);
        }

        public void executeCommand(RpcCommand<? extends MessageLite, CONNECTION_TYPE> cmd) {
            try {
                ConnectionResult result = this.futureConnection.get();
                if (result.ok()) {
                    if (result.hadToConnect()) {
                        cmd.connectionSucceeded((MessageLite)((Object)result.connection));
                    } else {
                        cmd.connectionAvailable(result.connection);
                    }
                } else {
                    cmd.connectionFailed(result.failure.type, result.failure.throwable);
                }
            }
            catch (InterruptedException e) {
                cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, e);
            }
            catch (ExecutionException e) {
                cmd.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, e.getCause());
            }
        }
    }

    private class Exec
    extends SerializedExecutor<ConnectionRunner> {
        public Exec() {
            super(ReconnectingConnection.this.name, r -> r.run(), false);
        }

        @Override
        protected void runException(ConnectionRunner command, Throwable t) {
            command.futureConnection.complete(new ConnectionResult(ReconnectingConnection.this, t));
        }
    }

    protected static class CloseHandler
    implements ChannelFutureListener {
        private CONNECTION_TYPE connection;
        private ChannelFutureListener parent;
        final /* synthetic */ ReconnectingConnection this$0;

        public CloseHandler(CONNECTION_TYPE connection, ChannelFutureListener parent) {
            this.this$0 = this$0;
            this.connection = connection;
            this.parent = parent;
            ((RemoteConnection)this.connection).setupLazyNotifyOnClose();
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean wasSet = this.this$0.connectionHolder.compareAndSet(this.connection, null);
            this.parent.operationComplete(future);
            if (wasSet) {
                this.this$0.scheduleNotifyHandler(this.connection, 0);
            }
        }
    }

    public class CloseHandlerCreator {
        public ChannelFutureListener getHandler(CONNECTION_TYPE connection, ChannelFutureListener parent) {
            return new CloseHandler(ReconnectingConnection.this, connection, parent);
        }
    }
}

