/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.carrotsearch.hppc.IntObjectHashMap;
import cdjd.com.carrotsearch.hppc.procedures.IntObjectProcedure;
import cdjd.com.dremio.common.exceptions.UserRemoteException;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.rpc.ChannelClosedException;
import cdjd.com.dremio.exec.rpc.ChannelListenerWithCoordinationId;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcOutcome;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.com.google.common.base.Preconditions;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.channel.ChannelFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestIdMap {
    private static final Logger logger = LoggerFactory.getLogger(RequestIdMap.class);
    private final AtomicInteger lastCoordinationId = new AtomicInteger();
    private final AtomicInteger pendingRequests = new AtomicInteger(0);
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final IntObjectHashMap<RpcOutcome<?>> map = new IntObjectHashMap();
    private final String connectionName;
    private volatile RpcException cachedException;
    private volatile boolean lazyNotify;

    public RequestIdMap(String connectionName) {
        this.connectionName = connectionName;
        this.lazyNotify = false;
    }

    void setupLazyNotification() {
        this.lazyNotify = true;
    }

    void channelClosed(Throwable ex) {
        this.isOpen.set(false);
        if (ex != null) {
            RpcException mappedException = RpcException.mapException(ex);
            if (this.lazyNotify) {
                this.cachedException = mappedException;
            } else {
                this.doNotify(mappedException, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyExceptionIfAny(boolean force) {
        if (this.cachedException == null) {
            return true;
        }
        if (!force && this.pendingRequests.get() > 0) {
            boolean empty;
            IntObjectHashMap<RpcOutcome<?>> intObjectHashMap = this.map;
            synchronized (intObjectHashMap) {
                empty = this.map.isEmpty();
            }
            if (!empty) {
                return false;
            }
        }
        this.doNotify(this.cachedException, force);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify(RpcException ex, boolean force) {
        Object clonedMap;
        IntObjectHashMap<RpcOutcome<?>> intObjectHashMap = this.map;
        synchronized (intObjectHashMap) {
            clonedMap = this.map.clone();
            this.map.clear();
        }
        if (force) {
            logger.info("Forcefully notifying closed channel; {} requests still awaiting completion notification; Notifying {} errors", (Object)this.pendingRequests.get(), (Object)((IntObjectHashMap)clonedMap).size());
        }
        ((IntObjectHashMap)clonedMap).forEach(new SetExceptionProcedure(ex));
        this.cachedException = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ChannelListenerWithCoordinationId createNewRpcListener(RpcOutcomeListener<V> handler, Class<V> clazz, RemoteConnection connection) {
        RpcListener<V> old;
        int i = this.lastCoordinationId.incrementAndGet();
        this.pendingRequests.incrementAndGet();
        RpcListener<V> future = new RpcListener<V>(handler, clazz, i, connection);
        IntObjectHashMap<RpcOutcome<?>> intObjectHashMap = this.map;
        synchronized (intObjectHashMap) {
            Preconditions.checkState(this.isOpen.get(), "Attempted to send a message when connection is no longer valid. %s", (Object)this.connectionName);
            old = this.map.put(i, future);
        }
        Preconditions.checkArgument(old == null, "You attempted to reuse a coordination id when the previous coordination id has not been removed.  This is likely rpc future callback memory leak.");
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcOutcome<?> removeFromMap(int coordinationId) {
        RpcOutcome<?> rpc;
        IntObjectHashMap<RpcOutcome<?>> intObjectHashMap = this.map;
        synchronized (intObjectHashMap) {
            rpc = this.map.remove(coordinationId);
        }
        if (rpc == null) {
            throw new IllegalStateException("Attempting to retrieve an rpc that wasn't first stored in the rpc coordination queue.  This would most likely happen if you're opposite endpoint sent multiple messages on the same coordination id.");
        }
        return rpc;
    }

    public <V> RpcOutcome<V> getAndRemoveRpcOutcome(int rpcType, int coordinationId, Class<V> clazz) {
        RpcOutcome<?> rpc = this.removeFromMap(coordinationId);
        Class<?> outcomeClass = rpc.getOutcomeType();
        if (outcomeClass != clazz) {
            throw new IllegalStateException(String.format("RPC Engine had a submission and response configuration mismatch.  The RPC request that you submitted was defined with an expected response type of %s.  However, when the response returned, a call to getResponseDefaultInstance() with Rpc number %d provided an expected class of %s.  This means either your submission uses the wrong type definitionor your getResponseDefaultInstance() method responds the wrong instance type ", clazz.getCanonicalName(), rpcType, outcomeClass.getCanonicalName()));
        }
        RpcOutcome<?> crpc = rpc;
        return crpc;
    }

    public void recordRemoteFailure(int coordinationId, UserBitShared.DremioPBError failure) {
        try {
            RpcOutcome<?> rpc = this.removeFromMap(coordinationId);
            rpc.setException(UserRemoteException.create(failure));
        }
        catch (Exception ex) {
            logger.warn("Failed to remove from map.  Not a problem since we were updating on failed future.", ex);
        }
    }

    private class RpcListener<T>
    implements ChannelListenerWithCoordinationId,
    RpcOutcome<T> {
        final RpcOutcomeListener<T> handler;
        final Class<T> clazz;
        final int coordinationId;
        final RemoteConnection connection;

        public RpcListener(RpcOutcomeListener<T> handler, Class<T> clazz, int coordinationId, RemoteConnection connection) {
            this.handler = handler;
            this.clazz = clazz;
            this.coordinationId = coordinationId;
            this.connection = connection;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            RequestIdMap.this.pendingRequests.decrementAndGet();
            if (!future.isSuccess() && RequestIdMap.this.cachedException == null) {
                RequestIdMap.this.removeFromMap(this.coordinationId);
                if (future.channel().isActive()) {
                    if (future.cause() != null) {
                        this.setException(future.cause());
                    } else {
                        this.setException(new RpcException("Unknown failure when sending message."));
                    }
                } else {
                    this.setException(new ChannelClosedException());
                }
            }
        }

        @Override
        public void set(Object value, ByteBuf buffer) {
            assert (this.clazz.isAssignableFrom(value.getClass()));
            this.handler.success(value, buffer);
        }

        @Override
        public void setException(Throwable t) {
            this.handler.failed(RpcException.mapException(t));
        }

        @Override
        public Class<T> getOutcomeType() {
            return this.clazz;
        }

        @Override
        public int getCoordinationId() {
            return this.coordinationId;
        }

        @Override
        public void opNotStarted() {
            RequestIdMap.this.pendingRequests.decrementAndGet();
        }
    }

    private class SetExceptionProcedure
    implements IntObjectProcedure<RpcOutcome<?>> {
        final RpcException exception;

        public SetExceptionProcedure(RpcException exception) {
            this.exception = exception;
        }

        @Override
        public void apply(int key, RpcOutcome<?> value) {
            try {
                value.setException(this.exception);
            }
            catch (Exception e) {
                logger.warn("Failure while attempting to fail rpc response.", e);
            }
        }
    }
}

