/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.common.SerializedExecutor;
import cdjd.com.dremio.common.exceptions.UserException;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.rpc.Acks;
import cdjd.com.dremio.exec.rpc.ChannelClosedException;
import cdjd.com.dremio.exec.rpc.ChannelListenerWithCoordinationId;
import cdjd.com.dremio.exec.rpc.InboundRpcMessage;
import cdjd.com.dremio.exec.rpc.OutboundRpcMessage;
import cdjd.com.dremio.exec.rpc.RemoteConnection;
import cdjd.com.dremio.exec.rpc.Response;
import cdjd.com.dremio.exec.rpc.ResponseSender;
import cdjd.com.dremio.exec.rpc.RpcBus;
import cdjd.com.dremio.exec.rpc.RpcConfig;
import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcFuture;
import cdjd.com.dremio.exec.rpc.RpcFutureImpl;
import cdjd.com.dremio.exec.rpc.RpcOutcome;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.com.dremio.exec.rpc.UserRpcException;
import cdjd.com.dremio.telemetry.api.metrics.Histogram;
import cdjd.com.dremio.telemetry.api.metrics.Metrics;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.base.Stopwatch;
import cdjd.com.google.protobuf.ByteString;
import cdjd.com.google.protobuf.Internal;
import cdjd.com.google.protobuf.InvalidProtocolBufferException;
import cdjd.com.google.protobuf.MessageLite;
import cdjd.com.google.protobuf.Parser;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.ByteBufInputStream;
import cdjd.io.netty.channel.Channel;
import cdjd.io.netty.channel.ChannelFuture;
import cdjd.io.netty.channel.ChannelFutureListener;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.channel.socket.SocketChannel;
import cdjd.io.netty.handler.codec.MessageToMessageDecoder;
import cdjd.io.netty.util.concurrent.Future;
import cdjd.io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcBus<T extends Internal.EnumLite, C extends RemoteConnection>
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String PROTOCOL_ENCODER = "protocol-encoder";
    protected static final String HANDSHAKE_HANDLER = "handshake-handler";
    protected static final String MESSAGE_HANDLER = "message-handler";
    protected static final String EXCEPTION_HANDLER = "exception-handler";
    private static final OutboundRpcMessage PONG = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.PONG, 0, 0, (MessageLite)Acks.OK, new ByteBuf[0]);
    private static final boolean ENABLE_SEPARATE_THREADS = "true".equals(System.getProperty("dremio.enable_rpc_offload", "false"));
    public static final long RPC_DELAY_WARNING_THRESHOLD = Integer.parseInt(System.getProperty("dremio.exec.rpcDelayWarning", "500"));
    protected final RpcConfig rpcConfig;
    private final Histogram sendDurations;
    private SecondFailureHandler RESPONSE_FAILURE_FAILURE = new SecondFailureHandler();

    protected abstract MessageLite getResponseDefaultInstance(int var1) throws RpcException;

    protected void handle(C connection, int coordinationId, int rpcType, byte[] pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        this.handle(connection, rpcType, pBody, dBody, sender);
    }

    protected void handle(C connection, int rpcType, byte[] pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        sender.send(this.handle(connection, rpcType, pBody, dBody));
    }

    protected abstract Response handle(C var1, int var2, byte[] var3, ByteBuf var4) throws RpcException;

    public RpcBus(RpcConfig rpcConfig) {
        this.rpcConfig = rpcConfig;
        this.sendDurations = Metrics.newHistogram(rpcConfig.getName() + "-send-durations-ms", Metrics.ResetType.NEVER);
    }

    <SEND extends MessageLite, RECEIVE extends MessageLite> RpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        RpcFutureImpl rpcFuture = new RpcFutureImpl();
        this.send(rpcFuture, connection, rpcType, protobufBody, clazz, dataBodies);
        return rpcFuture;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.send(listener, connection, rpcType, protobufBody, clazz, false, dataBodies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        block13: {
            Preconditions.checkArgument(allowInEventLoop || !((RemoteConnection)connection).inEventLoop(), "You attempted to send while inside the rpc event thread. This isn't allowed because sending will block if the channel is backed up.");
            boolean completed = false;
            ChannelListenerWithCoordinationId futureListener = null;
            try {
                if (!allowInEventLoop && !((RemoteConnection)connection).blockOnNotWritable(listener)) {
                    return;
                }
                assert (!Arrays.asList(dataBodies).contains(null));
                assert (this.rpcConfig.checkSend((Internal.EnumLite)rpcType, protobufBody.getClass(), clazz));
                Preconditions.checkNotNull(protobufBody);
                ByteBuf[] stopwatch = Stopwatch.createStarted();
                futureListener = ((RemoteConnection)connection).createNewRpcListener(listener, clazz);
                OutboundRpcMessage m3 = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.REQUEST, (Internal.EnumLite)rpcType, futureListener.getCoordinationId(), (MessageLite)protobufBody, dataBodies);
                ChannelFuture channelFuture = ((RemoteConnection)connection).getChannel().writeAndFlush(m3);
                channelFuture.addListener(futureListener);
                channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)arg_0 -> this.lambda$send$0((Stopwatch)stopwatch, arg_0)));
                completed = true;
            }
            catch (IllegalStateException e) {
                listener.failed(new RpcException("Failure sending message. " + e.getMessage(), "CONNECTION_INVALID", null, e));
            }
            catch (AssertionError | Exception e) {
                listener.failed(new RpcException("Failure sending message.", (Throwable)e));
            }
            finally {
                if (completed) break block13;
                if (futureListener != null) {
                    futureListener.opNotStarted();
                }
                if (dataBodies == null) break block13;
                for (ByteBuf b : dataBodies) {
                    b.release();
                }
            }
        }
    }

    public abstract C initRemoteConnection(SocketChannel var1);

    protected ChannelFutureListener newCloseListener(SocketChannel channel, C connection) {
        return new ChannelClosedHandler(this, connection, (Channel)channel);
    }

    public static <T> T get(ByteBuf pBody, Parser<T> parser) throws RpcException {
        try {
            ByteBufInputStream is = new ByteBufInputStream(pBody);
            return parser.parseFrom(is);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    public static <T> T get(byte[] pBody, Parser<T> parser) throws RpcException {
        try {
            return parser.parseFrom(pBody);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    public static <T> T get(ByteString pBody, Parser<T> parser) throws RpcException {
        try {
            return parser.parseFrom(pBody);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    private /* synthetic */ void lambda$send$0(Stopwatch stopwatch, Future future) throws Exception {
        this.sendDurations.update(stopwatch.elapsed(TimeUnit.MILLISECONDS), new String[0]);
    }

    private static class ResponseEvent
    implements Runnable {
        private final int rpcType;
        private final int coordinationId;
        private final byte[] pBody;
        private final ByteBuf dBody;
        private final C connection;
        final /* synthetic */ RpcBus this$0;

        public ResponseEvent(C connection, int rpcType, int coordinationId, byte[] pBody, ByteBuf dBody) {
            this.this$0 = var1_1;
            this.rpcType = rpcType;
            this.coordinationId = coordinationId;
            this.pBody = pBody;
            this.dBody = dBody;
            this.connection = connection;
            if (dBody != null) {
                dBody.retain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MessageLite m3 = this.this$0.getResponseDefaultInstance(this.rpcType);
                assert (this.this$0.rpcConfig.checkReceive(this.rpcType, m3.getClass()));
                RpcOutcome<?> rpcFuture = ((RemoteConnection)this.connection).getAndRemoveRpcOutcome(this.rpcType, this.coordinationId, m3.getClass());
                Parser<? extends MessageLite> parser = m3.getParserForType();
                MessageLite value = parser.parseFrom(this.pBody);
                rpcFuture.set(value, this.dBody);
            }
            catch (Exception ex) {
                this.this$0.logger.error("Failure while handling response.", ex);
            }
            finally {
                if (this.dBody != null) {
                    this.dBody.release();
                }
            }
        }
    }

    private static class RequestEvent
    implements Runnable {
        private final ResponseSenderImpl sender;
        private final C connection;
        private final int rpcType;
        private final byte[] pBody;
        private final ByteBuf dBody;
        final /* synthetic */ RpcBus this$0;

        RequestEvent(int coordinationId, C connection, int rpcType, byte[] pBody, ByteBuf dBody) {
            this.this$0 = var1_1;
            this.sender = var1_1.new ResponseSenderImpl();
            this.connection = connection;
            this.rpcType = rpcType;
            this.pBody = pBody;
            this.dBody = dBody;
            this.sender.set((RemoteConnection)connection, coordinationId);
            if (dBody != null) {
                dBody.retain();
            }
        }

        @Override
        public void run() {
            try {
                this.this$0.handle(this.connection, this.sender.coordinationId, this.rpcType, this.pBody, this.dBody, this.sender);
            }
            catch (UserRpcException e) {
                this.sender.sendFailure(e);
            }
            catch (Exception e) {
                UserRpcException genericException = new UserRpcException(CoordinationProtos.NodeEndpoint.getDefaultInstance(), "Remote message leaked.", e);
                if (!this.sender.sendFailure(genericException, false)) {
                    this.this$0.logger.error("Message handling failed for rpcType {} after response already sent. Logging locally since it cannot be communicated back to sender.", (Object)this.rpcType, (Object)e);
                }
            }
            finally {
                if (this.dBody != null) {
                    this.dBody.release();
                }
            }
        }
    }

    class RpcEventHandler
    extends SerializedExecutor<Runnable> {
        public RpcEventHandler(Executor underlyingExecutor) {
            super(RpcBus.this.rpcConfig.getName() + "-rpc-event-queue", underlyingExecutor, false);
        }

        @Override
        protected void runException(Runnable command, Throwable t) {
            RpcBus.this.logger.error("Failure while running rpc command.", t);
        }
    }

    protected static class InboundHandler
    extends MessageToMessageDecoder<InboundRpcMessage> {
        private final SerializedExecutor<Runnable> exec;
        private final C connection;
        final /* synthetic */ RpcBus this$0;

        public InboundHandler(C connection) {
            this.this$0 = this$0;
            Preconditions.checkNotNull(connection);
            this.connection = connection;
            Executor underlyingExecutor = ENABLE_SEPARATE_THREADS ? this$0.rpcConfig.getExecutor() : this$0.new SameExecutor();
            this.exec = this$0.new RpcEventHandler(underlyingExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void decode(ChannelHandlerContext ctx, InboundRpcMessage msg, List<Object> output) throws Exception {
            block11: {
                long time;
                if (!ctx.channel().isOpen()) {
                    return;
                }
                SocketChannel channel = ((RemoteConnection)this.connection).getChannel();
                Stopwatch watch = Stopwatch.createStarted();
                try {
                    switch (msg.mode) {
                        case REQUEST: {
                            RequestEvent reqEvent = new RequestEvent(this.this$0, msg.coordinationId, this.connection, msg.rpcType, msg.pBody, msg.dBody);
                            this.exec.execute(reqEvent);
                            break;
                        }
                        case RESPONSE: {
                            ResponseEvent respEvent = new ResponseEvent(this.this$0, this.connection, msg.rpcType, msg.coordinationId, msg.pBody, msg.dBody);
                            this.exec.execute(respEvent);
                            break;
                        }
                        case RESPONSE_FAILURE: {
                            UserBitShared.DremioPBError failure = UserBitShared.DremioPBError.parseFrom(msg.pBody);
                            ((RemoteConnection)this.connection).recordRemoteFailure(msg.coordinationId, failure);
                            break;
                        }
                        case PING: {
                            channel.writeAndFlush(PONG);
                            break;
                        }
                        case PONG: {
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    time = watch.elapsed(TimeUnit.MILLISECONDS);
                    if (time <= RPC_DELAY_WARNING_THRESHOLD) break block11;
                }
                catch (Throwable throwable) {
                    long time2 = watch.elapsed(TimeUnit.MILLISECONDS);
                    if (time2 > RPC_DELAY_WARNING_THRESHOLD) {
                        this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", msg.mode, msg.rpcType, RPC_DELAY_WARNING_THRESHOLD, time2));
                    }
                    msg.release();
                    throw throwable;
                }
                this.this$0.logger.warn(String.format("Message of mode %s of rpc type %d took longer than %dms.  Actual duration was %dms.", msg.mode, msg.rpcType, RPC_DELAY_WARNING_THRESHOLD, time));
            }
            msg.release();
        }
    }

    private class SameExecutor
    implements Executor {
        private SameExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private class SecondFailureHandler
    implements ChannelFutureListener {
        private SecondFailureHandler() {
        }

        @Override
        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                RpcBus.this.logger.error("Failure sending response failure message, closing connection.", future.cause());
                future.channel().close();
            }
        }
    }

    private class ResponseSenderImpl
    implements ResponseSender {
        private cdjd.com.dremio.exec.rpc.RpcBus$ResponseSenderImpl.FirstFailureHandler failureHandler = new FirstFailureHandler();
        private RemoteConnection connection;
        private int coordinationId;
        private final AtomicBoolean sent = new AtomicBoolean(false);

        void set(RemoteConnection connection, int coordinationId) {
            this.connection = connection;
            this.coordinationId = coordinationId;
            this.sent.set(false);
        }

        @Override
        public void send(Response r) {
            assert (RpcBus.this.rpcConfig.checkResponseSend(r.rpcType, r.pBody.getClass()));
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, r.rpcType, this.coordinationId, r.pBody, r.dBodies);
            ChannelFuture future = this.connection.getChannel().writeAndFlush(outMessage);
            future.addListener((GenericFutureListener<? extends Future<? super Void>>)this.failureHandler);
        }

        private void sendOnce() {
            if (!this.sent.compareAndSet(false, true)) {
                throw new IllegalStateException("Attempted to utilize a sender multiple times.");
            }
        }

        @Override
        public void sendFailure(UserRpcException e) {
            this.sendFailure(e, true);
        }

        private boolean sendFailure(UserRpcException e, boolean failOnAlreadySent) {
            if (failOnAlreadySent) {
                this.sendOnce();
            } else if (!this.sent.compareAndSet(false, true)) {
                return false;
            }
            UserException uex = UserException.systemError(e).addIdentity(e.getEndpoint()).build(RpcBus.this.logger);
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE_FAILURE, 0, this.coordinationId, (MessageLite)uex.getOrCreatePBError(false), new ByteBuf[0]);
            ChannelFuture future = this.connection.getChannel().writeAndFlush(outMessage);
            future.addListener(RpcBus.this.RESPONSE_FAILURE_FAILURE);
            return true;
        }

        private class FirstFailureHandler
        implements ChannelFutureListener {
            private FirstFailureHandler() {
            }

            @Override
            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    Throwable ex = future.cause();
                    if (ex == null) {
                        ResponseSenderImpl.this.sendFailure(new UserRpcException(null, "Unknown failure when sending message.", null));
                    } else {
                        ResponseSenderImpl.this.sendFailure(new UserRpcException(null, "Failure when sending message.", ex));
                    }
                }
            }
        }
    }

    public class ChannelClosedHandler
    implements ChannelFutureListener {
        final C clientConnection;

        public ChannelClosedHandler(Channel clientConnection) {
            this.clientConnection = clientConnection;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            String msg = String.format("[%s]: Channel closed %s", RpcBus.this.rpcConfig.getName(), ((RemoteConnection)this.clientConnection).getName());
            ChannelClosedException ex = future.cause() != null ? new ChannelClosedException(msg, future.cause()) : new ChannelClosedException(msg);
            RpcBus.this.logger.info(msg);
            ((RemoteConnection)this.clientConnection).channelClosed(ex);
        }
    }
}

