/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.exec.rpc;

import cdjd.com.dremio.exec.rpc.RpcException;
import cdjd.com.dremio.exec.rpc.RpcFuture;
import cdjd.com.dremio.exec.rpc.RpcOutcomeListener;
import cdjd.com.google.common.util.concurrent.AbstractFuture;
import cdjd.com.google.common.util.concurrent.ForwardingListenableFuture;
import cdjd.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcFutureImpl<V>
extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
implements RpcFuture<V>,
RpcOutcomeListener<V> {
    static final Logger logger = LoggerFactory.getLogger(RpcFutureImpl.class);
    private volatile ByteBuf buffer;

    public RpcFutureImpl() {
        super(new InnerFuture());
    }

    @Override
    public void failed(RpcException ex) {
        ((InnerFuture)this.delegate()).setException(ex);
    }

    @Override
    public void success(V value, ByteBuf buffer) {
        this.buffer = buffer;
        ((InnerFuture)this.delegate()).setValue(value);
    }

    @Override
    public void interrupted(InterruptedException ex) {
        ((InnerFuture)this.delegate()).cancel(true);
    }

    @Override
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public void release() {
        if (this.buffer != null) {
            this.buffer.release();
        }
    }

    private static class InnerFuture<T>
    extends AbstractFuture<T> {
        private InnerFuture() {
        }

        void setValue(T value) {
            super.set(value);
        }

        @Override
        protected boolean setException(Throwable t) {
            return super.setException(t);
        }
    }
}

