/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io;

public interface ExponentialBackoff {
    public static double getBackoffWaitTime(int attemptNumber, int baseMillis, int maxMillis) {
        if ((double)attemptNumber >= Math.log(Long.MAX_VALUE / (long)baseMillis) / Math.log(2.0)) {
            return maxMillis;
        }
        return Math.min((long)maxMillis, (long)baseMillis * (1L << attemptNumber));
    }

    default public void backoffWait(int attemptNumber) {
        try {
            double sleep = ExponentialBackoff.getBackoffWaitTime(attemptNumber, this.getBaseMillis(), this.getMaxMillis());
            Thread.sleep((long)(Math.random() * (sleep + 1.0)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getBaseMillis();

    public int getMaxMillis();
}

