/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.io;

import cdjd.com.dremio.io.AsyncByteReader;
import cdjd.com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ReusableAsyncByteReader
implements AsyncByteReader {
    private final AtomicLong refCount = new AtomicLong(1L);

    public final long addRef() {
        Preconditions.checkArgument(this.refCount.get() > 0L, "Illegal state while reusing async byte reader");
        return this.refCount.incrementAndGet();
    }

    public final long releaseRef() {
        Preconditions.checkArgument(this.refCount.get() > 0L, "Illegal state while dropping ref on async byte reader");
        return this.refCount.decrementAndGet();
    }

    protected void onClose() throws Exception {
    }

    @Override
    public final void close() throws Exception {
        long currentRef = this.releaseRef();
        Preconditions.checkArgument(currentRef >= 0L, "Invalid ref count on async byte reader");
        if (currentRef == 0L) {
            this.onClose();
        }
    }
}

