/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.sabot.rpc.user;

import cdjd.com.dremio.exec.proto.GeneralRPCProtos;
import cdjd.com.dremio.exec.proto.UserBitShared;
import cdjd.com.dremio.exec.proto.UserProtos;
import cdjd.com.dremio.exec.rpc.InboundRpcMessage;
import cdjd.com.dremio.sabot.rpc.user.BaseBackwardsCompatibilityHandler;
import cdjd.io.netty.buffer.ByteBuf;
import cdjd.io.netty.buffer.NettyArrowBuf;
import cdjd.io.netty.channel.ChannelHandlerContext;
import cdjd.io.netty.handler.codec.MessageToMessageDecoder;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import java.util.List;

class BackwardsCompatibilityDecoder
extends MessageToMessageDecoder<InboundRpcMessage> {
    private final BufferAllocator allocator;
    private final BaseBackwardsCompatibilityHandler handler;

    BackwardsCompatibilityDecoder(BufferAllocator allocator, BaseBackwardsCompatibilityHandler handler) {
        super(InboundRpcMessage.class);
        this.allocator = allocator;
        this.handler = handler;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, InboundRpcMessage msg, List<Object> out) throws Exception {
        if (msg.mode == GeneralRPCProtos.RpcMode.REQUEST && msg.rpcType == UserProtos.RpcType.QUERY_DATA.getNumber()) {
            UserBitShared.QueryData oldHeader = UserBitShared.QueryData.parseFrom(msg.pBody);
            ByteBuf oldData = msg.dBody;
            BaseBackwardsCompatibilityHandler.QueryBatch oldBatch = new BaseBackwardsCompatibilityHandler.QueryBatch(oldHeader, oldData);
            BaseBackwardsCompatibilityHandler.QueryBatch newBatch = this.handler.makeBatchCompatible(oldBatch);
            ByteBuf newBuffer = this.consolidateBuffers(newBatch.getBuffers());
            out.add(new InboundRpcMessage(msg.mode, msg.rpcType, msg.coordinationId, newBatch.getHeader().toByteArray(), newBuffer));
        } else {
            out.add(msg);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.handler.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf consolidateBuffers(ByteBuf ... buffers) {
        if (buffers.length == 0) {
            return NettyArrowBuf.unwrapBuffer(this.allocator.buffer(0L));
        }
        if (buffers.length == 1) {
            return buffers[0];
        }
        int readableBytes = 0;
        for (ByteBuf buffer : buffers) {
            readableBytes += buffer.readableBytes();
        }
        try {
            NettyArrowBuf newBuffer = NettyArrowBuf.unwrapBuffer(this.allocator.buffer(readableBytes));
            for (ByteBuf buffer : buffers) {
                ((ByteBuf)newBuffer).writeBytes(buffer);
            }
            NettyArrowBuf nettyArrowBuf = newBuffer;
            return nettyArrowBuf;
        }
        finally {
            BackwardsCompatibilityDecoder.freeBuffers(buffers);
        }
    }

    private static void freeBuffers(ByteBuf ... buffers) {
        for (ByteBuf buffer : buffers) {
            buffer.release();
        }
    }
}

