/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator;

import cdjd.com.amazonaws.auth.AWSCredentials;
import cdjd.com.amazonaws.auth.AWSCredentialsProvider;
import cdjd.com.amazonaws.auth.AWSSessionCredentials;
import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.common.utils.AssumeRoleCredentialsProvider;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class DremioAssumeRoleCredentialsProviderV1
implements AWSCredentialsProvider,
AutoCloseable {
    public static final String ACCESS_KEY = "fs.s3a.access.key";
    public static final String SECRET_KEY = "fs.s3a.secret.key";
    public static final String SESSION_TOKEN = "session.token";
    private static Provider<AssumeRoleCredentialsProvider> credentialsProvider;

    public static void setAssumeRoleProvider(Provider<AssumeRoleCredentialsProvider> credentialsProvider) {
        DremioAssumeRoleCredentialsProviderV1.credentialsProvider = credentialsProvider;
    }

    public Map<String, String> getCredentialsMap() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        AWSCredentials awsCredentials = this.getCredentials();
        map.put(ACCESS_KEY, awsCredentials.getAWSAccessKeyId());
        map.put(SECRET_KEY, awsCredentials.getAWSSecretKey());
        if (awsCredentials instanceof AWSSessionCredentials) {
            map.put(SESSION_TOKEN, ((AWSSessionCredentials)awsCredentials).getSessionToken());
        }
        return map;
    }

    public AWSCredentials getCredentials() {
        final AwsCredentials awsCredentials = ((AssumeRoleCredentialsProvider)credentialsProvider.get()).resolveCredentials();
        return new AWSSessionCredentials(){

            public String getSessionToken() {
                if (awsCredentials instanceof AwsSessionCredentials) {
                    return ((AwsSessionCredentials)awsCredentials).sessionToken();
                }
                return "";
            }

            public String getAWSAccessKeyId() {
                return awsCredentials.accessKeyId();
            }

            public String getAWSSecretKey() {
                return awsCredentials.secretAccessKey();
            }
        };
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable)credentialsProvider.get());
    }

    public void refresh() {
    }
}

