/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.local;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.exec.proto.CoordinationProtos;
import cdjd.com.dremio.service.coordinator.AbstractServiceSet;
import cdjd.com.dremio.service.coordinator.ClusterCoordinator;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.RegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.Maps;
import cdjd.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClusterCoordinator
extends ClusterCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(LocalClusterCoordinator.class);
    private final ConcurrentMap<String, DistributedSemaphore> semaphores = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Election> elections = Maps.newConcurrentMap();
    private final ConcurrentMap<String, LocalServiceSet> serviceSets = Maps.newConcurrentMap();

    @VisibleForTesting
    public static LocalClusterCoordinator newRunningCoordinator() throws Exception {
        LocalClusterCoordinator coordinator = new LocalClusterCoordinator();
        coordinator.start();
        return coordinator;
    }

    public LocalClusterCoordinator() {
        logger.info("Local Cluster Coordinator is up.");
        for (ClusterCoordinator.Role role : ClusterCoordinator.Role.values()) {
            this.serviceSets.put(role.name(), new LocalServiceSet(role.name()));
        }
    }

    @Override
    public void close() throws Exception {
        logger.info("Stopping Local Cluster Coordinator");
        AutoCloseables.close(this.serviceSets.values());
        logger.info("Stopped Local Cluster Coordinator");
    }

    @Override
    public void start() {
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return (ServiceSet)this.serviceSets.get(role.name());
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String name) {
        return this.serviceSets.computeIfAbsent(name, s2 -> new LocalServiceSet((String)s2));
    }

    @Override
    public Iterable<String> getServiceNames() {
        return this.serviceSets.keySet();
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        if (!this.semaphores.containsKey(name)) {
            this.semaphores.putIfAbsent(name, new LocalSemaphore(maximumLeases));
        }
        return (DistributedSemaphore)this.semaphores.get(name);
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        if (!this.elections.containsKey(name)) {
            this.elections.putIfAbsent(name, new Election());
        }
        return ((Election)this.elections.get(name)).joinElection(listener);
    }

    private final class Election {
        private final Queue<Candidate> waiting = new LinkedBlockingQueue<Candidate>();
        private volatile Candidate currentLeader = null;

        private Election() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ElectionRegistrationHandle joinElection(ElectionListener listener) {
            final Candidate candidate = new Candidate(listener);
            Election election = this;
            synchronized (election) {
                if (this.currentLeader == null) {
                    this.currentLeader = candidate;
                    candidate.listener.onElected();
                } else {
                    this.waiting.add(candidate);
                }
            }
            return new ElectionRegistrationHandle(){

                @Override
                public void close() {
                    Election.this.leaveElection(candidate);
                }

                @Override
                public Object synchronizer() {
                    return this;
                }

                @Override
                public int instanceCount() {
                    return Election.this.waiting.size();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void leaveElection(Candidate candidate) {
            Election election = this;
            synchronized (election) {
                if (this.currentLeader == candidate) {
                    this.currentLeader = this.waiting.poll();
                    if (this.currentLeader != null) {
                        this.currentLeader.listener.onElected();
                    }
                } else {
                    this.waiting.remove(candidate);
                }
            }
        }
    }

    private final class Candidate {
        private final ElectionListener listener;

        public Candidate(ElectionListener listener) {
            this.listener = listener;
        }
    }

    private class LocalSemaphore
    implements DistributedSemaphore {
        private final Semaphore semaphore;
        private final int size;
        private final LocalLease singleLease = new LocalLease(1);
        private final Map<DistributedSemaphore.UpdateListener, Void> listeners = Collections.synchronizedMap(new WeakHashMap());

        LocalSemaphore(int size) {
            this.semaphore = new Semaphore(size);
            this.size = size;
        }

        @Override
        public boolean hasOutstandingPermits() {
            return this.semaphore.availablePermits() < this.size;
        }

        @Override
        public DistributedSemaphore.DistributedLease acquire(int permits, long timeout, TimeUnit timeUnit) throws Exception {
            Preconditions.checkArgument(permits > 0, "permits must be a positive integer");
            this.update();
            if (!this.semaphore.tryAcquire(permits, timeout, timeUnit)) {
                return null;
            }
            return permits == 1 ? this.singleLease : new LocalLease(permits);
        }

        private void update() {
            ArrayList<DistributedSemaphore.UpdateListener> col = new ArrayList<DistributedSemaphore.UpdateListener>(this.listeners.keySet());
            for (DistributedSemaphore.UpdateListener l : col) {
                l.updated();
            }
        }

        @Override
        public boolean registerUpdateListener(DistributedSemaphore.UpdateListener listener) {
            this.listeners.put(() -> {
                try {
                    listener.updated();
                }
                catch (Exception e) {
                    logger.warn("Exception occurred while notifying listener.", e);
                }
            }, null);
            return true;
        }

        private class LocalLease
        implements DistributedSemaphore.DistributedLease {
            private final int permits;

            LocalLease(int permits) {
                this.permits = permits;
            }

            @Override
            public void close() throws Exception {
                LocalSemaphore.this.semaphore.release(this.permits);
                LocalSemaphore.this.update();
            }
        }
    }

    private final class LocalServiceSet
    extends AbstractServiceSet
    implements AutoCloseable {
        private final Map<RegistrationHandle, CoordinationProtos.NodeEndpoint> endpoints = new ConcurrentHashMap<RegistrationHandle, CoordinationProtos.NodeEndpoint>();
        private final String serviceName;

        public LocalServiceSet(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public RegistrationHandle register(CoordinationProtos.NodeEndpoint endpoint) {
            logger.debug("Endpoint registered {}. {}", (Object)this.serviceName, (Object)endpoint);
            Handle h2 = new Handle();
            this.endpoints.put(h2, endpoint);
            this.nodesRegistered(Sets.newHashSet(endpoint));
            return h2;
        }

        @Override
        public Collection<CoordinationProtos.NodeEndpoint> getAvailableEndpoints() {
            return Collections.unmodifiableCollection(this.endpoints.values());
        }

        public String toString() {
            return this.serviceName;
        }

        @Override
        public void close() throws Exception {
            logger.info("Stopping LocalServiceSet");
            this.clearListeners();
            this.endpoints.clear();
            logger.info("Stopped LocalServiceSet");
        }

        private class Handle
        implements RegistrationHandle {
            private final UUID id = UUID.randomUUID();

            private Handle() {
            }

            public int hashCode() {
                return Objects.hash(this.getOuterType(), this.id);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Handle other = (Handle)obj;
                return this.getOuterType().equals(other.getOuterType()) && this.id.equals(other.id);
            }

            private LocalServiceSet getOuterType() {
                return LocalServiceSet.this;
            }

            @Override
            public void close() {
                LocalServiceSet.this.endpoints.remove(this);
            }
        }
    }
}

