/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.zk;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.service.coordinator.ClusterCoordinator;
import cdjd.com.dremio.service.coordinator.ClusterElectionManager;
import cdjd.com.dremio.service.coordinator.ClusterServiceSetManager;
import cdjd.com.dremio.service.coordinator.ElectionListener;
import cdjd.com.dremio.service.coordinator.ElectionRegistrationHandle;
import cdjd.com.dremio.service.coordinator.ServiceSet;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterClient;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterConfig;
import cdjd.com.dremio.service.coordinator.zk.ZKServiceSet;
import cdjd.com.google.common.collect.Maps;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClusterServiceSetManager
implements ClusterServiceSetManager,
ClusterElectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ZKClusterServiceSetManager.class);
    private final ConcurrentMap<String, ZKServiceSet> serviceSets = Maps.newConcurrentMap();
    private final ZKClusterClient zkClient;

    public ZKClusterServiceSetManager(ZKClusterConfig config) throws IOException {
        this(config, (String)null);
    }

    public ZKClusterServiceSetManager(ZKClusterConfig config, String connect) throws IOException {
        this.zkClient = new ZKClusterClient(config, connect);
    }

    public ZKClusterServiceSetManager(ZKClusterConfig config, Provider<Integer> localPort) throws IOException {
        this.zkClient = new ZKClusterClient(config, localPort);
    }

    @Override
    public void start() throws Exception {
        this.zkClient.start();
    }

    @Override
    public ServiceSet getServiceSet(ClusterCoordinator.Role role) {
        return (ServiceSet)this.serviceSets.get(role.name());
    }

    @Override
    public ServiceSet getOrCreateServiceSet(String serviceName) {
        return this.serviceSets.computeIfAbsent(serviceName, s2 -> {
            ZKServiceSet newServiceSet = this.zkClient.newServiceSet(serviceName);
            try {
                newServiceSet.start();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to start %s service in Zookeeper", serviceName), e);
            }
            return newServiceSet;
        });
    }

    public ServiceSet getOrCreateServiceSet(String role, String serviceName) {
        return this.serviceSets.computeIfAbsent(role, s2 -> {
            ZKServiceSet newServiceSet = this.zkClient.newServiceSet(serviceName);
            try {
                newServiceSet.start();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to start %s service in Zookeeper", serviceName), e);
            }
            return newServiceSet;
        });
    }

    @Override
    public Iterable<String> getServiceNames() throws Exception {
        return this.zkClient.getServiceNames();
    }

    @Override
    public ElectionRegistrationHandle joinElection(String name, ElectionListener listener) {
        return this.zkClient.joinElection(name, listener);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.serviceSets.values(), AutoCloseables.iter(this.zkClient));
    }

    public ZKClusterClient getZkClient() {
        return this.zkClient;
    }
}

